<?php
defined('ABSPATH') or exit;
?>
<div class="col-xs">
    <article id="post-<?php the_ID(); ?>" <?php post_class('chk-post-card h-full'); ?>>
        <?php if (has_post_thumbnail(get_the_ID())) : ?>
            <div class="chk-post-card__thumbnail pos-relative lh-0 z-1 overflow-hidden chk-effect-zoom">
                <div class="chk-post-card__date if-center pos-absolute z-1 flex-col text-center">
                    <?php echo sprintf('%s', get_the_date('d')); ?>
                    <span>
                        <?php echo sprintf('%s', get_the_date('M')); ?>
                    </span>
                </div>
                <a href="<?php echo get_the_permalink(); ?>" class="chk-post-card__image lh-0 d-block">
                    <?php
                    the_post_thumbnail('chk_blog', array(
                        'class' => 'w-full h-auto transition-all',
                        'loading' => 'lazy',
                        'alt' => get_the_title()
                    ));
                    ?>
                </a>
            </div>
        <?php endif; ?>
        <div class="chk-post-card__content">
            <?php
            $tag_title = chakavak_get_option('related_card_title_tag', 'h4');
            echo '<' . $tag_title . ' class="chk-post-card__title py-4">';
            echo '<a href="' . get_the_permalink() . '" class="transition-all text-current">';
            echo get_the_title();
            echo '</a>';
            echo '</' . $tag_title . '>';
            ?>
        </div>
    </article>
</div>