<?php
defined('ABSPATH') or exit;
if (chakavak_get_option('portfolio_related')) { ?>
    <div class="chk-single-portfolio__related-wrap">
        <div class="container">
            <div class="chk-single-portfolio__related">
                <?php if (!empty('portfolio_related_title')): ?>
                    <span class="chk-single-portfolio__related-title d-block">
                        <?php echo esc_html(chakavak_get_option('portfolio_related_title')); ?>
                    </span>
                <?php endif; ?>
                <?php
                global $post;
                $per_slide = chakavak_get_option('portfolio_related_items') !== null ? chakavak_get_option('portfolio_related_items') : '';
                $in_desktop = $per_slide['portfolio_related_items_desktop'] ? $per_slide['portfolio_related_items_desktop'] : '4';
                $in_tablet = $per_slide['portfolio_related_items_tablet'] ? $per_slide['portfolio_related_items_tablet'] : '3';
                $in_mobile = $per_slide['portfolio_related_items_mobile'] ? $per_slide['portfolio_related_items_mobile'] : '2';
                // get the custom post type's taxonomy terms
                $custom_taxterms = wp_get_object_terms($post->ID, 'portfolio_cat', array('fields' => 'ids'));
                // arguments
                $args = array(
                    'post_type' => 'portfolio',
                    'post_status' => 'publish',
                    'posts_per_page' => 4,
                    'ignore_sticky_posts' => 1,
                    'orderby' => 'rand',
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'portfolio_cat',
                            'field' => 'id',
                            'terms' => $custom_taxterms
                        )
                    ),
                    'post__not_in' => array($post->ID),
                );

                $related_query = new WP_Query($args);
                if ($related_query->have_posts()) :
                    ?>
                    <div class="row row-cols-xs-1 row-cols-ms-<?php echo $in_mobile; ?> row-cols-md-<?php echo $in_mobile; ?> row-cols-lg-<?php echo $in_desktop; ?>">
                        <?php while ($related_query->have_posts()) : $related_query->the_post(); ?>
                            <div class="col-xs">
                                <?php include locate_template('template-parts/single-portfolio/card-related.php'); ?>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php
                endif;
                wp_reset_query();
                ?>
            </div>
        </div>
    </div>
<?php } ?>