<?php
$details_title_tag = chakavak_get_option('portfolio_details_title_tag', 'h4');
$details_title = chakavak_get_option('portfolio_details_title');
$features = chakavak_get_meta('chakavak_portfolio_meta', 'portfolio_features');
$summary = chakavak_get_meta('chakavak_portfolio_meta', 'portfolio_summary');
?>
<div class="chk-single-portfolio__details">
    <?php if (!empty($details_title)) {
        $ctitle = 'chk-single-portfolio__details-title';
        echo '<' . $details_title_tag . ' class="chk-single-portfolio__details-title">';
        echo esc_html($details_title);
        echo '</' . $details_title_tag . '>';
    } ?>

    <?php if ($features) : ?>
        <ul class="chk-single-portfolio__details-items d-flex flex-col pos-relative list-none p-0 m-0">
            <?php
            foreach ($features as $feature) {
                $label = $feature['feature_label'];
                $value = $feature['feature_value'];
                echo '<li class="chk-single-portfolio__details-item d-flex items-center w-full">';
                if (!empty($label)) {
                    echo '<span class="d-inline-block"><i class="chk-dot"></i>' . esc_html($label) . ' : </span>';
                }
                if (!empty($value)) {
                    echo '<span class="d-inline-block">' . esc_html($value) . '</span>';
                }
                echo '</li>';
            }
            ?>
        </ul>
    <?php endif; ?>
    <?php if (!empty($summary)) {
        echo '<div class="chk-single-portfolio__details-desc">' . $summary . '</div>';
    } ?>

    <div class="mt-auto d-flex justify-center">
        <?php chakavak_entry_sharing(); ?>
    </div>
</div>