<?php
defined('ABSPATH') or exit;
if (!function_exists('chakavak_page_header')) {
    function chakavak_page_header()
    {
        $pheader = '';
        if (get_post_meta(get_the_ID(), 'chakavak_page_meta', true)) {
            $pheader = chakavak_get_meta('chakavak_page_meta', 'page_header_switch', 'true');
            if (is_home() || is_archive() || is_search() || is_singular('post')) {
                $pheader = chakavak_get_meta('chakavak_page_meta', 'page_header_switch', 'true');
            }
            if (!$pheader) {
                return;
            }
        }

        if (!chakavak_get_option('pheader_switch') && !$pheader) {
            return;
        } else {
            $bg = '';
            if (!get_post_meta(get_the_ID(), 'chakavak_page_meta', true)) {
                $header_img = chakavak_get_option('page_header_img');
                $bg = is_array($header_img) && isset($header_img['url']) ? $header_img['url'] : '';
            } else {
                $img = chakavak_get_meta('chakavak_page_meta', 'page_header_bg_image');
                // اصلاح شده - بررسی می‌کند که آیا img یک آرایه است و کلید url دارد
                $images = is_array($img) && isset($img['url']) ? $img['url'] : '';
                if (!$images) {
                    $bg_url = chakavak_get_option('page_header_img');
                    // اصلاح شده - بررسی می‌کند که آیا bg_url یک آرایه است و کلید url دارد
                    $bg = is_array($bg_url) && isset($bg_url['url']) ? $bg_url['url'] : '';
                } else {
                    $bg = $images;
                }
            }
        }

        $title = '';
        if (is_home()) {
            $title = get_the_title(get_option('page_for_posts'));
        } elseif (is_archive()) {
            $title = chakavak_get_archive_title();
        } elseif (is_search()) {
            $title = sprintf(esc_html__('Search Results for: %s', 'chakavak'), get_search_query());
        } elseif (is_singular('post')) {
            $title = chakavak_get_option('ptitle_post') ?: get_the_title();
        } else {
            $title = get_the_title();
        }
        if (!$title) {
            return;
        }
        $title_tag = chakavak_get_option('pheader_title_tag', 'h2');

        $page_header_class = 'chk-page-header flex-middle d-flex w-full pos-relative overflow-hidden';
        $is_header_transparent = chakavak_get_option('header_transparent');
        $page_meta = get_post_meta(get_the_ID(), 'chakavak_page_meta', true);
        $page_header_trans = $page_meta ? chakavak_get_meta('chakavak_page_meta', 'header_is_trans', 'default') : 'default';

        if ($is_header_transparent || $page_header_trans === 'yes') {
            $page_header_class .= ' items-end';
        } else {
            $page_header_class .= ' items-center';
        }

        ?>
        <div class="<?php echo $page_header_class . ' ' . chakavak_get_option('page_header_align', 'text-center'); ?>" <?php if (!empty($bg)) { ?> style="background-image: url(<?php echo esc_url($bg); ?>);" <?php } ?>>
            <div class="container">
                <div class="chk-page-header__inner pos-relative z-1">
                    <?php
                    printf('<%1$s class="chk-page-header__title">%2$s</%1$s>', $title_tag, $title);
                    ?>
                    <?php chakavak_breadcrumbs(); ?>
                </div>
            </div>
        </div>
        <?php
    }
}