<?php

/**
 * @package Chakavak
 */
if (!defined('ABSPATH')) {
    exit;
}
$terms = get_the_terms(get_the_ID(), 'portfolio_cat');
$chk_get_portfolio_cat = [];
if (!empty($terms)) {
    foreach ($terms as $term) {
        $chk_get_portfolio_cat[] = $term->name;
    }
}

$thumb_size = '';
if (chakavak_get_option('portfolio_style') === 'grid') {
    $thumb_size = 'chk_portfolio';
} elseif (chakavak_get_option('portfolio_style') === 'masonry') {
    $thumb_size = 'chk_portfolio_masonry';
}

$card_class = 'chk-portfolio-card pos-relative w-full d-flex flex-col transition-all z-1 overflow-hidden';
if (chakavak_get_option('portfolio_style') === 'grid') {
    $card_class .= ' h-full';
} elseif (chakavak_get_option('portfolio_style') === 'masonry') {
    $card_class .= ' h-auto';
}

$chk_portfolio_item_cat = (!empty($chk_get_portfolio_cat)) ? implode(", ", $chk_get_portfolio_cat) : '';
?>
<article id="post-<?php the_ID(); ?>" <?php post_class($card_class); ?>>
    <?php if (has_post_thumbnail()): ?>
        <div class="chk-portfolio-card__thumbnail pos-relative overflow-hidden text-center z-1 lh-0">
            <?php the_post_thumbnail($thumb_size, [
                'class' => 'w-full h-auto transition-all',
                'loading' => 'lazy',
                'alt' => '' . get_the_title() . ''
            ]); ?>
            <?php if (chakavak_get_option('portfolio_sw_overly')) : ?>
                <span class="chk-portfolio-card__overlay">
                    <a href="<?php echo get_the_permalink(); ?>" class="chk-portfolio-card__readmore"><i class="ti-plus d-inline-block"></i></a>
                </span>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php
    $tag_title = chakavak_get_option('portfolio_card_title_tag', 'h2');
    $title_class = 'chk-portfolio-card__title px-8 py-4';
    if (chakavak_get_option('portfolio_title_inline')) {
        $title_class .= ' chk-title-inline';
    }
    echo '<' . $tag_title . ' class="' . $title_class . '">';
    echo '<a href="' . get_the_permalink() . '" class="transition-all text-current">';
    echo get_the_title();
    echo '</a>';
    echo '</' . $tag_title . '>';
    ?>

    <?php if (chakavak_get_option('portfolio_sw_cat', 'true')) : ?>
        <span class="chk-portfolio-card__cat transition-all px-8">
            <?php if (!empty($terms)) echo $chk_portfolio_item_cat; ?>
        </span>
    <?php endif; ?>


</article>