<?php

/**
 * @package Chakavak
 */
get_header();
$term_id = get_queried_object_id();
$taxonomy_meta = get_term_meta($term_id, 'chakavak_taxonomy_meta', true);

?>
<div class="py-32">
    <div class="container">
        <div class="d-flex flex-wrap">
            <div id="chk-archive-posts" class="chk-archive-posts <?php chakavak_content_columns(); ?>">
                <main id="main" class="site-main">

                    <?php if (chakavak_get_option('archive_posts_desc') == 'top-desc') {
                        $has_tax_desc = is_array($taxonomy_meta) && isset($taxonomy_meta['tax_desc']) && !empty($taxonomy_meta['tax_desc']);
                        $has_faq_items = is_array($taxonomy_meta) && isset($taxonomy_meta['faq_items']) && !empty($taxonomy_meta['faq_items']);
                        if (!empty(get_the_archive_description()) || $has_tax_desc || $has_faq_items) { ?>
                            <div class="chk-archive-desc top-desc">
                                <?php include locate_template('template-parts/category/description.php'); ?>
                                <?php include locate_template('template-parts/category/faq.php'); ?>
                            </div>
                    <?php }
                    } ?>

                    <?php if (have_posts()) : ?>
                        <div class="<?php chakavak_posts_card_layouts();
                                    chakavak_posts_style() ?>">
                            <?php if (chakavak_get_option('posts_card_layout') === 'grid') { ?>
                                <div class="<?php chakavak_archive_posts_columns_class(); ?>">
                                <?php } ?>
                                <?php while (have_posts()) {
                                    the_post(); ?>
                                    <div class="<?php echo (chakavak_get_option('posts_card_layout') === 'grid') ? 'col-xs' : 'pb-16'; ?>">
                                        <?php get_template_part('template-parts/content', get_post_type()); ?>
                                    </div>
                                <?php } ?>
                                <?php if (chakavak_get_option('posts_card_layout') === 'grid') { ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php else :
                        get_template_part('template-parts/content', 'none');
                    endif; ?>

                    <?php chakavak_posts_navigation('standard'); ?>

                    <?php if (chakavak_get_option('archive_posts_desc') == 'bottom-desc') {
                        $has_tax_desc = is_array($taxonomy_meta) && isset($taxonomy_meta['tax_desc']) && !empty($taxonomy_meta['tax_desc']);
                        $has_faq_items = is_array($taxonomy_meta) && isset($taxonomy_meta['faq_items']) && !empty($taxonomy_meta['faq_items']);
                        if (!empty(get_the_archive_description()) || $has_tax_desc || $has_faq_items) { ?>
                            <div class="chk-archive-desc bottom-desc">
                                <?php include locate_template('template-parts/category/description.php'); ?>
                                <?php include locate_template('template-parts/category/faq.php'); ?>
                            </div>
                    <?php }
                    } ?>
                </main>
            </div>
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>
<?php get_footer(); ?>