<?php

/**
 * The template for displaying all single posts
 * @package Chakavak
 */

get_header();

if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('single')) { ?>
    <div class="padding-default">
        <div class="container">
            <div class="d-flex flex-wrap">
                <div id="chk-single-post" class="chk-single-post <?php chakavak_content_columns(); ?>">
                    <?php do_action('chakavak_before_single_post'); ?>
                    <main id="chk-single-post-main" class="chk-single-post__main">
                        <?php
                        while (have_posts()) :
                            the_post();
                            get_template_part('template-parts/content', 'single');
                        endwhile;

                        if (chakavak_get_option('single_post_author_box')) {
                            chakavak_author_info_box();
                        }

                        if (chakavak_get_option('single_post_post_nav')) {
                            chakavak_single_post_nav('post');
                        }

                        if (chakavak_get_option('single_post_related')) {
                            chakavak_related_posts();
                        }

                        do_action('chakavak_before_single_comments');
                        if (comments_open() || get_comments_number()) :
                            comments_template();
                        endif;
                        do_action('chakavak_after_single_comments');

                        ?>

                    </main><!-- #main -->
                    <?php do_action('chakavak_after_single_post'); ?>
                </div><!-- #primary -->
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
<?php }


get_footer();
