<?php

/**
 * The template for displaying archive pages
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Chakavak
 */
get_header();
?>
<div class="py-32">
    <div class="container">
        <div class="d-flex flex-wrap">
            <div id="chk-archive-posts" class="chk-archive-posts <?php chakavak_content_columns(); ?>">
                <?php do_action('chakavak_before_main_blog'); ?>
                <main id="main" class="site-main">
                    <?php if (chakavak_get_option('archive_posts_desc') == 'top-desc') {
                        if (get_the_archive_description()) { ?>
                            <div class="chk-archive-desc top-desc">
                                <div class="pos-relative w-full chk-classic-editor">
                                    <?php the_archive_description(); ?>
                                </div>
                            </div>
                    <?php }
                    } ?>

                    <?php if (have_posts()) : ?>
                        <div class="<?php chakavak_posts_card_layouts();
                                    chakavak_posts_style() ?>">
                            <?php if (chakavak_get_option('posts_card_layout') === 'grid') { ?>
                                <div class="<?php chakavak_archive_posts_columns_class(); ?>">
                                <?php } ?>
                                <?php while (have_posts()) {
                                    the_post(); ?>
                                    <div class="<?php echo (chakavak_get_option('posts_card_layout') === 'grid') ? 'col-xs' : 'pb-16'; ?>">
                                        <?php get_template_part('template-parts/content', get_post_type()); ?>
                                    </div>
                                <?php } ?>
                                <?php if (chakavak_get_option('posts_card_layout') === 'grid') { ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php else :
                        get_template_part('template-parts/content', 'none');
                    endif; ?>

                    <?php chakavak_posts_navigation('standard'); ?>

                    <?php if (chakavak_get_option('archive_position_desc') == 'bottom-desc') {
                        if (get_the_archive_description()) { ?>
                            <div class="chk-archive-desc bottom-desc">
                                <div class="pos-relative w-full chk-classic-editor">
                                    <?php the_archive_description(); ?>
                                </div>
                            </div>
                    <?php }
                    } ?>
                </main>

                <?php do_action('chakavak_after_main_blog'); ?>
            </div><!-- #primary -->

            <?php get_sidebar(); ?>

        </div>
    </div>
</div>

<?php
get_footer();
