<?php
if (!defined('ABSPATH')) {
    exit;
}

add_action('init', 'chakavak_create_portfolio');
function chakavak_create_portfolio()
{
    //$slug = __('Portfolio', 'chakavak');
    $slug = __('portfolio', 'chakavak');
    $labels = [
        'name' => __('Portfolio', 'chakavak'),
        'singular_name' => $slug,
        'menu_name' => __('Portfolio', 'chakavak'),
        'add_new' => __('Add New', 'chakavak'),
        'add_new_item' => __('Add New Portfolio', 'chakavak'),
        'new_item' => __('New Portfolio', 'chakavak'),
        'edit_item' => __('Edit Portfolio', 'chakavak'),
        'view_item' => __('View Portfolio', 'chakavak'),
        'all_items' => __('All Portfolios', 'chakavak'),
        'search_items' => __('Search Portfolios', 'chakavak'),
        'parent_item_colon' => __('Parent Portfolios:', 'chakavak'),
        'not_found' => __('No portfolios found..', 'chakavak'),
        'not_found_in_trash' => __('No portfolios found in Trash.', 'chakavak'),
    ];
    $args = [
        'labels' => $labels,
        'hierarchical' => false,
        'description' => __('List Portfolio', 'chakavak'),
        'supports' => ['title', 'editor', 'thumbnail', 'comments', 'post-formats', 'excerpt'],
        'taxonomies' => ['categories'],
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => null,
        'menu_icon' => 'dashicons-portfolio',
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => ['slug' => 'portfolio'], //In Permalink Settings page
        'capability_type' => 'post',
        'show_in_rest' => true,
    ];
    register_post_type('portfolio', $args);
}

add_action('init', 'chakavak_categories_hierarchical_taxonomy', 0);
//create a custom taxonomy name it Skillss for your posts
function chakavak_categories_hierarchical_taxonomy()
{

    // Add new taxonomy, make it hierarchical like categories
    //first do the translations part for GUI
    $labels = array(
        'name' => __('Categories', 'chakavak'),
        'singular_name' => __('Categories', 'chakavak'),
        'search_items' => __('Search categories', 'chakavak'),
        'all_items' => __('All categories', 'chakavak'),
        'parent_item' => __('Parent category', 'chakavak'),
        'parent_item_colon' => __('Parent category:', 'chakavak'),
        'edit_item' => __('Edit category', 'chakavak'),
        'update_item' => __('Update category', 'chakavak'),
        'add_new_item' => __('Add New category', 'chakavak'),
        'new_item_name' => __('New category name', 'chakavak'),
        'menu_name' => __('Categories', 'chakavak'),
    );
    // Now register the taxonomy
    register_taxonomy('portfolio_cat', array('portfolio'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'show_in_rest' => true,
        'show_in_nav_menus' => true,
        'public' => true,

        'rewrite' => array(
            'slug' => __('portfolio-cat', 'portfolio')
        ), //In Permalink Settings page
    ));
}

// footer post type
add_action('init', 'chakavak_create_builder');
function chakavak_create_builder()
{
    register_post_type(
        'chk_builders',
        array(
            'labels' => array(
                'name' => __('Builder', 'chakavak'),
                'singular_name' => __('Builder', 'chakavak'),
                'add_new' => __('Add New', 'chakavak'),
                'add_new_item' => __('Add New Builder', 'chakavak'),
                'edit' => __('Edit', 'chakavak'),
                'edit_item' => __('Edit Builder', 'chakavak'),
                'new_item' => __('New Builder', 'chakavak'),
                'view' => __('View', 'chakavak'),
                'view_item' => __('View Builder', 'chakavak'),
                'search_items' => __('Search Builders', 'chakavak'),
                'not_found' => __('No Builders found', 'chakavak'),
                'not_found_in_trash' => __('No Builders found in Trash', 'chakavak'),
                'parent' => __('Parent Builder', 'chakavak'),
            ),
            'hierarchical' => false,
            'public' => false,
            'show_ui' => true,
            'menu_position' => 60,
            'supports' => array(
                'title',
                'editor',
                'page-attributes',
                'custom-fields',
                'revisions'
            ),
            'menu_icon' => 'dashicons-editor-kitchensink',
            'show_in_menu' => false,
            'publicly_queryable' => true,
            'exclude_from_search' => true,
            'has_archive' => false,
            'query_var' => true,
            'can_export' => true,
            'show_in_rest' => true,
            'show_in_nav_menus' => true,
            //'capability_type'     => 'post'
        )
    );
}
