<?php
defined('ABSPATH') or exit;
?>

<div <?php echo $this->get_render_attribute_string('item'); ?>>

    <?php if ($item['is_rating']) : ?>
        <div class="chk-testimonial-1__rating ">
            <?php echo $this->rating_render($item['rating']); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($item['comment'])) : ?>
        <div class="chk-testimonial-1__comment">
            <?php echo esc_html($item['comment']); ?>
        </div>
    <?php endif; ?>

    <div class="mt-auto">
        <div class="chk-testimonial-1__meta">
            <?php
            if (!empty($item['image']['url'])) {
                echo '<div class="chk-testimonial-1__image pos-relative">';
                echo '<img src="' . esc_attr($item['image']['url']) . '" alt="' . $item['name'] . '" width="10" height="10" loading="lazy"/>';
                echo '</div>';
            }
            ?>

            <div class="chk-testimonial-1__meta-text">
                <?php
                if (!empty($item['name'])) {
                    $name_class = 'chk-testimonial-1__name transition-all';
                    echo "<{$name_tag} class=\"{$name_class}\">";
                    echo esc_html($item['name']);
                    echo "</{$name_tag}>";
                }
                ?>

                <?php
                if (!empty($item['position'])) {
                    $name_class = 'chk-testimonial-1__position transition-all';
                    echo "<span class=\"{$name_class}\">";
                    echo esc_html($item['position']);
                    echo "</span>";
                }
                ?>
            </div>
        </div>
    </div>
</div>
