<?php
defined('ABSPATH') or exit;
$title_tag = $settings['title_tag'];
$title_class = 'chk-post-item__title transition-all';
if ($settings['title_inline_limit']) {
    $title_class .= ' chk-title-inline';
}
?>
<article id="post-<?php echo get_the_ID(); ?>" <?php post_class($post_cls); ?>>

    <div class="chk-post-item__content pos-relative z-1">
        <?php
        echo '<' . $title_tag . ' class="' . $title_class . '">';
        echo '<a href="' . $permalink . '" target="' . $settings['target_link'] . '">' . get_the_title() . '</a>';
        echo '</' . $title_tag . '>';
        ?>

        <?php if ($settings['show_cat'] == 'yes') : ?>
            <div class="chk-post-item__cat">
                <?php
                echo '<i class="ti-folder"></i>';
                $chk_post_all_cats = get_the_category();
                $chk_post_cat_list = array();
                if ($chk_post_all_cats) {
                    foreach ($chk_post_all_cats as $category) {
                        $chk_post_cat_list[] = '<a href="' . esc_url(get_category_link($category->term_id)) . '" title="' . esc_attr(sprintf(esc_html__('%s', 'chakavak'), $category->name)) . '" >' . esc_html($category->cat_name) . '</a>';
                    }
                    echo implode(' , ', $chk_post_cat_list);
                } ?>
            </div>
        <?php endif; ?>

        <?php
        if ($settings['show_excerpt'] == 'yes') : ?>
            <div class="chk-post-item__excerpt">
                <?php echo chakavak_short_text(get_the_excerpt(), intval($settings['excerpt_length'])) . ' ...'; ?>
            </div>
        <?php endif; ?>

    </div>

    <?php if (has_post_thumbnail(get_the_ID()) && $settings['show_image'] == 'yes') : ?>

        <div class="mt-auto pos-relative z-1">
            <div class="chk-post-item__thumbnail pos-relative lg-0 overflow-hidden chk-effect-<?php echo $settings['image_hover_effect']; ?>">

                <div class="chk-post-item__readmore w-full h-full f-center pos-absolute">
                    <a href="<?php echo esc_url($permalink); ?>" class="if-center">
                        <?php echo esc_html($settings['button_text']) ?>
                    </a>
                </div>

                <a href="<?php echo esc_url($permalink); ?>" class="chk-post-item__image lh-0 d-block">
                    <?php echo $image_html; ?>
                </a>

            </div>
        </div>


    <?php endif; ?>

    <div class="mt-auto">
        <ul class="chk-post-item__meta">
            <?php
            if ($settings['show_author'] == 'yes') {
                echo '<li class="chk-post-item__author"><i class="ti-edit-file"></i><a href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . esc_html(get_the_author()) . '</a></li>';
            }
            if ($settings['show_date'] == 'yes') {
                echo '<li class="chk-post-item__date"><i class="ti-calendar"></i><span class="d-inline-block">' . sprintf('%s', get_the_date()) . '</span></li>';
            }

            if ($settings['show_comments'] == 'yes') {
                echo '<li class="chk-post-item__comment"><i class="ti-comments"></i>' . get_comments_number() . '</li>';
            }
            ?>
        </ul>
    </div>

</article>