<?php
defined('ABSPATH') or exit;

use Elementor\Icons_Manager;

?>

<div class="chk-icon-box-1 chk-icon-box-1__s2 transition-all pos-relative z-1 overflow-hidden chk-bg-before">
    <div class="chk-icon-box-1__header d-flex">
        <?php if ($settings['icon_type'] != 'none') : ?>
            <div class="chk-icon-box-1__icon pos-relative if-center chk-bg-before transition-all z-1">
                <?php if ($settings['icon_type'] == 'font') {
                    Icons_Manager::render_icon($settings['icon_font'], [
                        'aria-hidden' => 'true',
                        'class' => 'pos-relative'
                    ]);
                } ?>
                <?php if ($settings['icon_type'] == 'image') { ?>
                    <img src="<?php echo esc_attr($settings['icon_image']['url']); ?>"
                         alt="icon-<?php echo $settings['_id'] ?>" class="pos-relative z-1">
                <?php } ?>
            </div>
        <?php endif; ?>

        <div class="chk-icon-box-1__content pos-relative z-1">
            <?php
            //title
            if (!empty($settings['title'])) {
                $title_tag = $settings['title_tag'];
                $title_class = 'chk-icon-box-1__title pos-relative z-1';
                echo "<{$title_tag} class=\"{$title_class}\">";
                Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'd-inline-block transition-all');
                echo esc_html($settings['title']);
                Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                echo "</{$title_tag}>";
            }

            //subtitle
            if (!empty($settings['subtitle'])) {
                $subtitle_tag = $settings['subtitle_tag'];
                $subtitle_class = 'chk-icon-box-1__subtitle pos-relative z-1';
                echo "<{$subtitle_tag} class=\"{$subtitle_class}\">";
                echo esc_html($settings['subtitle']);
                echo "</{$subtitle_tag}>";
            }
            ?>
        </div>

    </div>

    <?php
    if (!empty($settings['desc'])) {
        $desc_class = 'chk-icon-box-1__desc pos-relative z-1';
        echo "<p class=\"{$desc_class}\">";
        echo wp_kses_post($settings['desc']);
        echo "</p>";
    }
    ?>
    <?php if ($settings['sw_button'] && !empty($settings['link']['url'])) { ?>
        <div class="mt-auto pos-relative z-1">
            <div class="chk-icon-box-1__button">
                <?php
                Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], 'if-center transition-all');
                echo '<span class="if-center">';
                echo esc_html($settings['text_button']);
                echo(is_rtl() ? '<i class="ti-arrow-large-left"></i>' : '<i class="ti-arrow-large-right"></i>');
                echo '</span>';
                Chakavak_Controls_Elementor::render_end_link($this, $settings['link']);
                ?>
            </div>
        </div>

    <?php } ?>
</div>