<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Icon Search
 */
class Chakavak_Search_Icon extends Widget_Base
{
    const NAME = 'chk_search_icon';
    const CATEGORY = 'chakavak_header_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Search Icon', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-search';
    }

    public function get_script_depends()
    {
        return ['jquery'];
    }

    public function get_keywords()
    {
        return ['Search', 'Search Icon', esc_html__('Search Icon', 'chakavak'), esc_html__('search', 'chakavak')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'style_icon_section',
            [
                'label' => __('Icon toggle', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'toggle_size',
            [
                'label' => __('Toggle icon size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'toggle_bg_size',
            [
                'label' => __('Toggle background Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'toggle_border',
                'label' => __('Border', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-isearch__toggle',
                'exclude' => ['color'],
            ]
        );

        $this->add_responsive_control(
            'toggle_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('toggle_tabs');

        $this->start_controls_tab(
            'toggle_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_color_normal',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'toggle_border_color_normal',
            [
                'label' => __('Toggle border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-100)',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'toggle_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_bg_normal',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-isearch__toggle',

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'toggle_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_color_hover',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle:is(:hover,:focus)' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'toggle_border_color_hover',
            [
                'label' => __('Toggle border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__toggle:is(:hover,:focus)' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'toggle_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_bg_hover',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-isearch__toggle:before',

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'style_form_section',
            [
                'label' => __('Form', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'form_overlay',
            [
                'label' => __('Overlay background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-search-overlay' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'form_bg',
            [
                'label' => __('Form background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'form_radius',
            [
                'label' => __('Form border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        /*Input */
        $this->add_control(
            'input_heading',
            [
                'label' => __('Input text', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'input_placeholder_text',
            [
                'label' => esc_html__('Placeholder text', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter Placeholder', 'chakavak'),
                'default' => esc_html__('Search here...', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'exclude' => [
                    'line_height',
                    'letter_spacing',
                ],
                'selector' => '{{WRAPPER}} .chk-isearch__form input[type=search]',
            ]
        );

        $this->add_responsive_control(
            'input_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form input[type=search]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'allowed_dimensions' => 'horizontal',
                'placeholder' => [
                    'top' => '',
                    'right' => '',
                    'bottom' => '',
                    'left' => '',
                ],
            ]
        );

        $this->add_control(
            'input_palceholder_color',
            [
                'label' => __('Placeholder color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form input[type=search]::placeholder' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'input_color',
            [
                'label' => __('Input color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form input[type=search]' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'input_bg_color',
            [
                'label' => __('Input background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form input[type=search]' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'input_border_color',
            [
                'label' => __('Input border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form input[type=search]' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'input_border_color_focus',
            [
                'label' => __('Input border focus color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form input[type=search]:focus' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        /*Button Submit */
        $this->add_control(
            'submit_heading',
            [
                'label' => __('Submit button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'submit_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 40,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('submit_tabs');

        $this->start_controls_tab(
            'submit_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'submit_color_normal',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submit_bgcolor_normal',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'submit_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'submit_color_hover',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form button:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'submit_bgcolor_hover',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-isearch__form button:is(:hover,:focus)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'style_close_section',
            [
                'label' => __('Close', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'close_size',
            [
                'label' => __('Icon size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-search-overlay:after' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'close_color',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-search-overlay:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_sticky_toggle_section',
            [
                'label' => __('Sticky toggle', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('toggle_sticky_tabs');

        $this->start_controls_tab(
            'toggle_sticky_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_sticky_color_normal',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-isearch__toggle' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'toggle_sticky_border_color_normal',
            [
                'label' => __('Toggle border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-100)',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-isearch__toggle' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'toggle_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_sticky_bg_normal',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .scrolled .chk-isearch__toggle',

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'toggle_sticky_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'toggle_sticky_color_hover',
            [
                'label' => __('Toggle color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-isearch__toggle:is(:hover,:focus)' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'toggle_sticky_border_color_hover',
            [
                'label' => __('Toggle border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-isearch__toggle:is(:hover,:focus)' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'toggle_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'toggle_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'toggle_sticky_bg_hover',
                'label' => esc_html__('Toggle background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .scrolled  .chk-isearch__toggle:before',

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('form', 'class', 'chk-isearch__form overflow-hidden pos-relative');
        $placeholder = $settings['input_placeholder_text'] ? $settings['input_placeholder_text'] : __('Search here...', 'chakavak');
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">

            <div class="chk-isearch chk-header-item lh-1">
                <button id="chk-search-toggle" class="chk-isearch__toggle chk-isearch-open chk-bg-before if-center pos-relative z-1 transition-all">
                    <i class="ti-search pos-relative z-1"></i>
                </button>
            </div>

            <div class="chk-isearch__popup">
                <div class="chk-site-overlay chk-search-overlay chk-isearch-open"></div>
                <div class="chk-isearch__popup-content pos-relative z-20 w-full">
                    <div class="container">
                        <div <?php echo $this->get_render_attribute_string('form'); ?>>
                            <form method="get" class="pos-relative d-flex w-full items-center" action="<?php echo esc_url(home_url('/')); ?>">
                                <label for="search-field" class="sr-only"><?php esc_attr_e($placeholder) ?></label>
                                <input type="search" id="search-field" value="<?php echo esc_attr(get_search_query()) ?>" name="s" placeholder="<?php esc_attr_e($placeholder) ?>">
                                <button type="submit" class="if-center text-center p-0 border-0 transition-all"><i class="ti-search"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Search_Icon());
