<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Mobile Menu
 */
class Chakavak_MobileMenu extends Widget_Base
{
    const NAME = 'chk_mmobile';
    const CATEGORY = 'chakavak_header_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Mobile Menu', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-select';
    }

    public function get_keywords()
    {
        return ['menu', 'mobile', 'nav', esc_html__('Main Navigation', 'chakavak'), esc_html__('Mobile Menu', 'chakavak')];
    }

    public function get_script_depends()
    {
        return ['jquery'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Menu mobile', 'chakavak'),
            ]
        );

        $menus = $this->get_available_menus();

        $this->add_control(
            'nav_menu',
            [
                'label' => esc_html__('Select menu', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'multiple' => false,
                'options' => $menus,
                'default' => array_keys($menus)[0],
                'save_default' => true,

            ]
        );

        $this->add_control(
            'pos_menu',
            [
                'label' => __('Position', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'chk-on-right',
                'options' => [
                    'chk-on-left' => __('On Left', 'chakavak'),
                    'chk-on-right' => __('On Right', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'logo_text',
            [
                'label' => __('Text logo', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'default' => __('chakavak', 'chakavak'),
            ]
        );

        $this->add_control(
            'contact_info_heading',
            [
                'label' => __('Contact info', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'info_text',
            [
                'label' => __('Text', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Enter a text', 'chakavak'),
                'default' => 'info@email.com',
            ]
        );

        $repeater->add_control(
            'info_icon',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'ti-email',
                    'library' => 'theme-icons',
                ],
                'fa4compatibility' => 'icon',
            ]
        );

        $repeater->add_control(
            'info_link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->add_control(
            'info_list',
            [
                'label' => __('Contact info', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'info_text' => '021-99887700',
                        'info_link' => ['url' => 'tel:02199887700'],
                        'info_icon' => ['value' => 'ti-phone', 'library' => 'theme-icons'],
                    ],
                    [
                        'info_text' => '0912-9998877',
                        'info_link' => ['url' => 'tel:09129998877'],
                        'info_icon' => ['value' => 'ti-mobile', 'library' => 'theme-icons'],
                    ],
                    [
                        'info_text' => 'info@chakavak.org',
                        'info_link' => ['url' => 'mailto:info@chakavak.org'],
                        'info_icon' => ['value' => 'ti-email', 'library' => 'theme-icons'],
                    ],
                ],
                'title_field' => '{{{ info_text }}}',
            ]
        );

        //Social
        $this->add_control(
            'socials_heading',
            [
                'label' => __('Socials', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater2 = new Repeater();

        $repeater2->add_control(
            'social_icon',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [],
                'fa4compatibility' => 'icon',
            ]
        );

        $repeater2->add_control(
            'social_link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->add_control(
            'social_list',
            [
                'label' => 'Socials',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater2->get_controls(),
                'default' => [
                    [
                        'social_icon' => [
                            'value' => 'ti ti-logo-facebook',
                        ],
                    ],
                ],
                'title_field' => '<# var migrated = "undefined" !== typeof __fa4_migrated, social = ( "undefined" === typeof social ) ? false : social; #>{{{ elementor.helpers.getSocialNetworkNameFromIcon( social_icon, social, true, migrated, true ) }}}',
            ]
        );

        $this->end_controls_section();

        /*** Style ***/
        $this->start_controls_section(
            'style_icon_section',
            [
                'label' => __('Toggle icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'toggle_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__toggle button' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .chk-mmenu__toggle button:after,{{WRAPPER}} .chk-mmenu__toggle button:before' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_mmenu_section',
            [
                'label' => __('Menu content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bg_mmenu',
            [
                'label' => __('Background', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__wrapper' => 'background: {{VALUE}};',
                ]
            ]
        );

        //logo style
        $this->add_control(
            'heading_logo',
            [
                'label' => __('Text logo', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'logo_tag',
            [
                'label' => __('Logo tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
                'condition' => [
                    'logo_text!' => ''
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'logo_typography',
                'selector' => '{{WRAPPER}} .chk-mmenu__logo',
                'condition' => [
                    'logo_text!' => ''
                ],
            ]
        );

        $this->add_control(
            'logo_color',
            [
                'label' => __('Logo color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__logo' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'logo_text!' => ''
                ],
            ]
        );


        //Close button
        $this->add_control(
            'heading_close',
            [
                'label' => __('Close', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'close_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 1,
                        'max' => 40,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__close' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('close_tabs');

        $this->start_controls_tab(
            'close_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'close_color_normal',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__close' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'close_bg_normal',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__close' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'close_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'close_color_hover',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__close:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'close_bg_hover',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__close:is(:hover,:focus)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();


        //Menu Items
        $this->add_control(
            'heading_menu_item',
            [
                'label' => __('Menu items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'mmenu_typography',
                'selector' => '{{WRAPPER}} .chk-mmenu__items ul li a ,{{WRAPPER}} .chk-mmenu__items>li>a',
            ]
        );

        $this->add_control(
            'mmenu_border_color',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__items > li' => 'border-bottom-color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items ul >li' => 'border-bottom-color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'mmenu_link_color',
            [
                'label' => __('Link color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__items > li > a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items ul li a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items > li.menu-item-has-children' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items  ul > li.menu-item-has-children' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'mmenu_link_color_hover',
            [
                'label' => __('Link color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__items > li > a:hover' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items ul li a:hover' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items ul li.show-submenu' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items > li.show-submenu > a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items ul li.show-submenu > a' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__items>li.show-submenu' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();

        //bottom
        $this->start_controls_section(
            'contact_info_section',
            [
                'label' => __('Contact info', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_contact',
            [
                'label' => __('Contact', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'cinfo_alignment',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__info' => 'align-items: {{VALUE}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'cinfo_gap',
            [
                'label' => __('Space between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.1,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__info' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cinfo_typography',
                'selector' => '{{WRAPPER}} .chk-mmenu__info-text',
            ]
        );

        $this->add_control(
            'cinfo_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__info li' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'cinfo_color_hover',
            [
                'label' => __('Link color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__info li:is(:hover,:focus)' => 'color:{{VALUE}}',
                    '{{WRAPPER}} .chk-mmenu__info li:is(:hover,:focus) a' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'social_section',
            [
                'label' => __('Social icons', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'social_alignment',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__socials' => 'justify-content: {{VALUE}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'social_size',
            [
                'label' => __('Space between', 'chakavak'),
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.1,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__socials a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-mmenu__socials a svg' => 'width: {{SIZE}}{{UNIT}};height:auto;',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_space',
            [
                'label' => __('Space between', 'chakavak'),
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.1,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__socials' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'social_color',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__wrapper .chk-mmenu__socials a' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'social_color_hover',
            [
                'label' => __('Icon color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-mmenu__wrapper .chk-mmenu__socials a:is(:hover,:focus)' => 'color:{{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_sticky_toggle_section',
            [
                'label' => __('Sticky toggle', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'toggle_sticky_color',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .scrolled .chk-mmenu__toggle button' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .scrolled .chk-mmenu__toggle button:after,{{WRAPPER}} .scrolled .chk-mmenu__toggle button:before' => 'background-color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function get_available_menus()
    {

        $menus = wp_get_nav_menus();
        $options = [];
        foreach ($menus as $menu) {
            $options[$menu->slug] = $menu->name;
        }

        return $options;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element lh-1">
            <div class="chk-mmenu chk-header-item">

                <div id="chk-mmenu-toggle" class="chk-mmenu__toggle if-center cursor-pointer z-1 ">
                    <button aria-label="menu-toggle"></button>
                </div>

                <div class="chk-site-overlay chk-mmenu-overlay"></div>

                <div class="chk-mmenu__wrapper pos-fixed top-0 bottom-0 z-9999 <?php echo $settings['pos_menu']; ?>">
                    <div class="chk-mmenu__inner top-0 d-flex h-full flex-col pos-relative">
                        <div class="chk-mmenu__header">

                            <?php if ($settings['logo_text']) {
                                $logo_tag = $settings['logo_tag'];
                                $logo_class = 'chk-mmenu__logo';
                                $this->add_render_attribute('logo_text', 'class', $logo_class);
                                printf(
                                    '<%1$s %2$s>%3$s</%1$s>',
                                    $logo_tag,
                                    $this->get_render_attribute_string('logo_text'),
                                    esc_html(esc_html($settings['logo_text']))
                                );
                            } ?>

                            <button class="chk-mmenu__close if-center transition-all overflow-hidden" aria-label="<?php echo esc_html__('Menu Close Button'); ?>"><i class="ti-close"></i></button>
                        </div>

                        <nav class="chk-mmenu__nav">
                            <?php
                            $menu_class = 'chk-mmenu__items list-none p-0 m-0';
                            wp_nav_menu(array(
                                'menu' => $settings['nav_menu'],
                                'menu_class' => $menu_class,
                                'container' => '',
                                'fallback_cb' => 'wp_page_menu',
                            ));
                            ?>
                        </nav>

                        <div class="chk-mmenu__footer">

                            <?php if ($settings['info_list']) :
                                $cinfo = 'mmenu__contact d-flex items-center transition-all';
                                ?>
                                <ul class="chk-mmenu__info">
                                    <?php foreach ($settings['info_list'] as $key => $item) :
                                        $this->add_render_attribute('info', 'class', $cinfo);
                                        $this->add_inline_editing_attributes('info', 'none');
                                        ?>
                                        <li <?php echo $this->get_render_attribute_string('info'); ?>>
                                            <?php if (!empty($item['info_icon'])) { ?>
                                                <span>
                                                    <?php Icons_Manager::render_icon($item['info_icon'], ['aria-hidden' => 'true']); ?>
                                                </span>
                                            <?php }
                                            if (!empty($item['info_link']['url'])) {
                                                $link_key = 'link_' . $key;
                                                $this->add_render_attribute($link_key, 'class', 'chk-mmenu__info-text transition-all');
                                                $this->add_link_attributes($link_key, $item['info_link']);
                                                ?>
                                                <a <?php $this->print_render_attribute_string($link_key); ?>>
                                                    <?php echo esc_html($item['info_text']); ?>
                                                </a>
                                            <?php } else { ?>
                                                <span class="chk-mmenu__info-text">
                                                    <?php echo esc_html($item['info_text']); ?>
                                                </span>
                                            <?php } ?>
                                        </li>
                                    <?php endforeach;
                                    ?>
                                </ul>
                            <?php endif; ?>

                            <?php if ($settings['social_list']): ?>
                                <div class="chk-mmenu__socials">
                                    <?php foreach ($settings['social_list'] as $key => $item) :
                                        $migration_allowed = Icons_Manager::is_migration_allowed();
                                        $migrated = isset($item['__fa4_migrated']['social_icon']);
                                        $is_new = !isset($item['icon']) && $migration_allowed;
                                        if (!empty($item['icon']) || (!empty($item['social_icon']['value']) && $is_new)) :
                                            echo '<a href="' . $item['social_link']['url'] . '" class="pos-relative transition-all overflow-hidden">'; ?>
                                            <?php
                                            if ($is_new || $migrated) {
                                                Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true']);
                                            } else { ?>
                                                <i class="<?php echo esc_attr($item['icon']); ?>" aria-hidden="true"></i>
                                            <?php }
                                            echo '</a>'; ?>
                                        <?php endif;
                                    endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_MobileMenu());
