<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Menu
 */
class Chakavak_Menu extends Widget_Base
{
    const NAME = 'chk_menu';
    const CATEGORY = 'chakavak_header_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Main Navigation', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-nav-menu';
    }

    public function get_keywords()
    {
        return ['menu', 'navigation', esc_html__('Main Navigation', 'chakavak'), esc_html__('Menu', 'chakavak')];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Menu', 'chakavak'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $menus = $this->get_available_menus();

        $this->add_control(
            'nav_menu',
            [
                'label' => esc_html__('Select Menu', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'multiple' => false,
                'options' => $menus,
                'default' => array_keys($menus)[0],
                'save_default' => true,

            ]
        );

        $this->end_controls_section();

        /*** Style ***/
        //menu parents
        $this->start_controls_section(
            'style_menu_section',
            [
                'label' => __('Main Menu', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'nav_typography',
                'selector' => '{{WRAPPER}} .chk-navbar__menu>li>a , {{WRAPPER}} .chk-navbar__menu ul li a',
            ]
        );

        $this->add_control(
            'menu_item_style',
            [
                'label' => __('Menu items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'space_left_right_item',
            [
                'label' => __('Spacing Between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu>li' => 'margin:0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space_top_bottom_item',
            [
                'label' => __('spacing top & bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu>li>a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Link color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu>li>a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-navbar__menu ul li a' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'text_hover_color',
            [
                'label' => __('Link hover color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu > li > a:is(:hover, :focus),
					 {{WRAPPER}} .chk-navbar__menu > li:hover > a' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        //Dropdown Menu
        $this->start_controls_section(
            'style_smenu_section',
            [
                'label' => __('Sub Menu', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'submenu_width',
            [
                'label' => __('Width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 180,
                        'max' => 700,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu ul' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'submenu_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'submenu_shadow',
                'fields_options' => [
                    'box_shadow_type' => [
                        'default' => 'yes'
                    ],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => '0',
                            'vertical' => '0',
                            'blur' => '10',
                            'color' => 'rgba(30,34,40,0.06)'
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-navbar__menu ul',
            ]
        );

        $this->add_control(
            'submenu_bg',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu ul' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_title',
            [
                'label' => __('Menu items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'submenu_link_color',
            [
                'label' => __('Link color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu ul li a' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'submenu_link_color_hover',
            [
                'label' => __('Link hover color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-navbar__menu ul:hover,
					 {{WRAPPER}} .chk-navbar__menu ul li.menu-item-has-children:hover > a' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

        //Sticky Menu

        $this->start_controls_section(
            'style_sticky_menu_section',
            [
                'label' => __('Sticky menu', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'sticky_text_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-header-item.scrolled ul.chk-navbar__menu > li > a' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'sticky_text_hover_color',
            [
                'label' => __('Text hover color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-header-item.scrolled ul.chk-navbar__menu > li > a:is(:hover, :focus),
					 {{WRAPPER}} .chk-header-item.scrolled ul.chk-navbar__menu > li.menu-item-has-children:hover > a' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->end_controls_section();
    }

    protected function get_available_menus()
    {
        $menus = wp_get_nav_menus();
        $options = [];
        foreach ($menus as $menu) {
            $options[$menu->slug] = $menu->name;
        }

        return $options;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('menu', 'class', 'chk-navbar chk-header-item');

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <nav id="chk-navbar" <?php echo $this->get_render_attribute_string('menu'); ?>>
                <?php
                wp_nav_menu(array(
                    'menu' => $settings['nav_menu'],
                    'container' => '',
                    'menu_id' => false,
                    'menu_class' => 'chk-navbar__menu',
                    'depth' => 3,
                    'fallback_cb' => 'wp_page_menu',
                ));
                ?>
            </nav>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Menu());
