<?php

namespace Elementor;
defined('ABSPATH') or exit;

/**
 * Widget Name: Work Hours
 */
class Chakavak_Work_Hours extends Widget_Base
{
    const NAME = 'chk_work_hours';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Work Hours', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-bullet-list';
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    public function get_keywords()
    {
        return ['clock', 'work', 'hours', 'time', esc_html__('work hours', 'chakavak')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_work_hours_days',
            [
                'label' => esc_html__('Work Hours - Days & Timings', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'enter_day',
            [
                'label' => esc_html__('Enter Day', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Saturday', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'enter_time',
            [
                'label' => esc_html__('Enter Time', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('8:00 AM - 4:00 PM', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'highlight_this',
            [
                'label' => esc_html__('Style This Day', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'highlight_this_day_color',
            [
                'label' => esc_html__('Day Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '#db6159',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .chk-work-hours__day' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'highlight_this' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'highlight_this_timing_color',
            [
                'label' => esc_html__('Time Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '#db6159',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .chk-work-hours__time' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'highlight_this' => 'yes',
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'highlight_this_bg_color',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
                'condition' => [
                    'highlight_this' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'work_days_timings',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ enter_day }}}',
                'prevent_empty' => false,
                'min_items' => 1,
                'max_items' => 7,
                'default' => [
                    [
                        'enter_day' => esc_html__('Saturday', 'chakavak'),
                        'enter_time' => esc_html__('9:00 AM - 2:00 PM', 'chakavak'),
                    ],
                    [
                        'enter_day' => esc_html__('Sunday', 'chakavak'),
                        'enter_time' => esc_html__('9:00 AM - 6:00 PM', 'chakavak'),
                    ],
                    [
                        'enter_day' => esc_html__('Monday', 'chakavak'),
                        'enter_time' => esc_html__('9:00 AM - 6:00 PM', 'chakavak'),
                    ],
                    [
                        'enter_day' => esc_html__('Tuesday', 'chakavak'),
                        'enter_time' => esc_html__('9:00 AM - 6:00 PM', 'chakavak'),
                    ],
                    [
                        'enter_day' => esc_html__('Wednesday', 'chakavak'),
                        'enter_time' => esc_html__('9:00 AM - 6:00 PM', 'chakavak'),
                    ],
                    [
                        'enter_day' => esc_html__('Thursday', 'chakavak'),
                        'enter_time' => esc_html__('9:00 AM - 1:00 PM', 'chakavak'),
                    ],
                    [
                        'enter_day' => esc_html__('Friday', 'chakavak'),
                        'enter_time' => esc_html__('Closed', 'chakavak'),
                        'highlight_this' => esc_html__('yes', 'chakavak'),
                    ],
                ],

            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'list_style',
            [
                'label' => esc_html__('List', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'list_spacing',
            [
                'label' => esc_html__('Row Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'list_padding',
            [
                'label' => esc_html__('Item padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'list_background',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '.chk-work-hours__item',
            ]
        );

        $this->add_responsive_control(
            'list_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'heading_divider',
            [
                'label' => __('Divider', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'day_divider',
            [
                'label' => esc_html__('Divider', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('YES', 'chakavak'),
                'label_off' => esc_html__('NO', 'chakavak'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'day_divider_style',
            [
                'label' => esc_html__('Border type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'solid' => esc_html__('Solid', 'chakavak'),
                    'dotted' => esc_html__('Dotted', 'chakavak'),
                    'dashed' => esc_html__('Dashed', 'chakavak'),
                ],
                'default' => 'solid',
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item:not(:last-child)' => 'border-bottom-style: {{VALUE}};',
                ],
                'condition' => [
                    'day_divider' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'day_divider_color',
            [
                'label' => esc_html__('Border style', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '#e2e8f0',
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item:not(:last-child)' => 'border-bottom-color: {{VALUE}};',
                ],
                'condition' => [
                    'day_divider' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_work_day_style',
            [
                'label' => esc_html__('Day and Time', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_day',
            [
                'label' => __('Day', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'work_day_typography',
                'selector' => '{{WRAPPER}} .chk-work-hours__day',
                'exclude' => [
                    'line_height',
                    'text_transform',
                    'font_style',
                    'text_decoration',
                    'word_spacing',
                ],
            ]
        );

        $this->add_responsive_control(
            'work_day_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__day' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'work_day_color',
            [
                'label' => esc_html__('Day color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__day' => 'color: {{VALUE}};',
                ],
            ]
        );

        /*** time */
        $this->add_control(
            'heading_time',
            [
                'label' => __('Time', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'work_time_typography',
                'selector' => '{{WRAPPER}} .chk-work-hours__time',
                'exclude' => [
                    'line_height',
                    'text_transform',
                    'font_style',
                    'text_decoration',
                    'word_spacing',
                ],
            ]
        );

        $this->add_responsive_control(
            'work_time_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__time' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'work_time_color',
            [
                'label' => esc_html__('Time color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__time' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'striped_effect_feature',
            [
                'label' => esc_html__('Striped effect', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('YES', 'chakavak'),
                'label_off' => esc_html__('NO', 'chakavak'),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'striped_effect_odd',
            [
                'label' => esc_html__('Striped odd rows color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-200)',
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item:nth-child(odd)' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'striped_effect_feature' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'striped_effect_even',
            [
                'label' => esc_html__('Striped even rows color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-white)',
                'selectors' => [
                    '{{WRAPPER}} .chk-work-hours__item:nth-child(even)' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'striped_effect_feature' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $day_divider = $settings['day_divider'];
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-work-hours">
                <?php if ($settings['work_days_timings']) :
                    $this->add_render_attribute('list', 'class', 'chk-work-hours__list list-none');
                    if (!empty($day_divider)) {
                        $this->add_render_attribute('list', 'class', 'chk-work-divider');
                    }
                    ?>
                    <ul <?php echo $this->get_render_attribute_string('list'); ?>>
                        <?php foreach ($settings['work_days_timings'] as $item) {
                            $enter_day = esc_html($item['enter_day']);
                            $enter_time = esc_html($item['enter_time']);
                            echo '<li class="elementor-repeater-item-' . $item["_id"] . ' chk-work-hours__item">';
                            echo '<span class="chk-work-hours__day">' . $enter_day . '</span>';
                            echo '<span class="chk-work-hours__time">' . $enter_time . '</span>';
                            echo '</li>';
                        } ?>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Work_Hours());
