<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Testimonials Carousel 1
 */
class Chakavak_Testimonails_Carousel_1 extends Widget_Base
{
    const NAME = 'chk_testimonials_carousel_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_name()
    {
        return self::NAME;
    }

    public function get_title()
    {
        return __('Testimonials Carousel 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-testimonial-carousel';
    }

    public function get_style_depends()
    {
        return [
            'swiper-bundle',
            'chk-testimonail-1',
        ];
    }

    public function get_script_depends()
    {
        return [
            'swiper-bundle',
            'chk-widgets'
        ];
    }

    public function get_keywords()
    {
        return ['review', 'carousel', esc_html__('testimonials', 'chakavak')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section',
            [
                'label' => esc_html__('Testimonials', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'testi_style',
            [
                'label' => __('Testimonial Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 's1',
                'options' => [
                    's1' => __('Style 1', 'chakavak'),
                ],
            ]
        );

        $repeater = new Repeater();

        Chakavak_Controls_Elementor::select_image($repeater, 'image', esc_html__('Choose Image', 'chakavak'));

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('Enter Name', 'chakavak'),
                'default' => esc_html__('Mrs. Zahedi', 'chakavak'),
            ]
        );
        $repeater->add_control(
            'position',
            [
                'label' => esc_html__('Position', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('Enter position', 'chakavak'),
                'default' => esc_html__('CEO', 'chakavak'),
            ]
        );
        $repeater->add_control(
            'comment',
            [
                'label' => esc_html__('Comment', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('Enter Comment', 'chakavak'),
                'default' => esc_html__('Lorem ipsum dolor sit amet saresw consectetur adipis cing elit sed do eiusmod tempor incidi duntut labore etolore magna aliqua ipsum suspen disse ultrices ida commodo.', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'is_rating',
            [
                'label' => esc_html__('Is Rating', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('No', 'chakavak'),
                'label_on' => esc_html__('Yes', 'chakavak'),
            ]
        );
        $repeater->add_control(
            'rating',
            [
                'label' => __('Rating <span class="elementor-control-field-description">( 0-5 )</span>', 'chakavak'),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5,
                'step' => 1,
                'default' => 5,
                'condition' => [
                    'is_rating' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'testimonials',
            [
                'label' => '',
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
                'default' => [
                    [
                        'name' => __('Mrs. Moghadam', 'chakavak'),
                        'position' => __('Ceo', 'chakavak'),
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'comment' => __('"I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment."', 'chakavak'),
                        'is_rating' => 'yes',
                        'rating' => 5,
                    ],
                    [
                        'name' => __('Mr. Ahmadi', 'chakavak'),
                        'position' => __('Developer', 'chakavak'),
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'comment' => __('"I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment."', 'chakavak'),
                        'is_rating' => 'yes',
                        'rating' => 4,
                    ],
                ],
            ]
        );

        Chakavak_Controls_Elementor::element_tag($this, 'name_tag', esc_html__('Name Tag', 'chakavak'), 'h4', '');

        $this->end_controls_section();

        Chakavak_Controls_Elementor::add_control_carousel($this, false);

        //item
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 999,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'background' => [
                    'label' => esc_html__('Background item', 'chakavak'),
                ],
                'selector' => '{{WRAPPER}} .chk-testimonial-1',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('Border', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-testimonial-1',
                'separator' => 'before'
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 3,
                                'blur' => 10,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.1)'
                            ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-testimonial-1',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'rating_style',
            [
                'label' => esc_html__('Rating', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'rating_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__rating' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'rating_size',
            [
                'label' => esc_html__('Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 80,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.5,
                        'max' => 30,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__rating i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'rating_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__rating i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'meta_style',
            [
                'label' => esc_html__('Meta', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'meta_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_horizontal_position(),
                'default' => '',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .s1 .chk-testimonial-1__meta' => 'justify-content: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_margin_top',
            [
                'label' => esc_html__('Spacing top', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.1,
                        'max' => 30,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .s1 .chk-testimonial-1__meta' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_heading',
            [
                'label' => __('Image', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_radius',
            [
                'label' => esc_html__('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_size',
            [
                'label' => esc_html__('Image Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0.1,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__image img' => 'width: {{SIZE}}{{UNIT}};height:auto;',
                ],
            ]
        );

        $this->add_control(
            'name_heading',
            [
                'label' => __('Name', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => "name_typography",
                'selector' => "{{WRAPPER}} .chk-testimonial-1__name",
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__name' => 'color: {{VALUE}};',
                ],
            ]
        );

        //postion
        $this->add_control(
            'position_heading',
            [
                'label' => esc_html__('Position', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => "position_typography",
                'selector' => "{{WRAPPER}} .chk-testimonial-1__position",
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__position' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Comments
        $this->start_controls_section(
            'comment_style',
            [
                'label' => esc_html__('Comment', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'comment_alignment',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment(),
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__comment' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => "comment_typography",
                'selector' => "{{WRAPPER}} .chk-testimonial-1__comment",
            ]
        );

        $this->add_control(
            'comment_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-testimonial-1__comment' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        Chakavak_Controls_Elementor::style_nav_carousel($this, ['ca_navigation' => 'yes']);
        Chakavak_Controls_Elementor::style_dots_carousel($this, ['ca_pagination' => 'yes']);
    }

    protected function rating_render($value = '')
    {
        $ratefull = '<i class="ti-star-fill active-rating"></i>';
        $rateO = '<i class="ti-star deactive-rating"></i>';

        if ($value == 5) {
            return $ratefull . $ratefull . $ratefull . $ratefull . $ratefull;
        } elseif ($value == 4) {
            return $ratefull . $ratefull . $ratefull . $ratefull . $rateO;
        } elseif ($value == 3) {
            return $ratefull . $ratefull . $ratefull . $rateO . $rateO;
        } elseif ($value == 2) {
            return $ratefull . $ratefull . $rateO . $rateO . $rateO;
        } elseif ($value == 1) {
            return $ratefull . $rateO . $rateO . $rateO . $rateO;
        } elseif ($value == 0) {
            return $rateO . $rateO . $rateO . $rateO . $rateO;
        }
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data_rtl = is_rtl() ? 'rtl' : 'ltr';
        $classes = [];
        $classes[] = 'chk-testimonials-1-group chk-testimonials-1-carousel swiper-slider-wrapper';
        $classes[] = 'chk-testimonials-1-' . $this->get_id();
        $this->add_render_attribute('wrapper', 'class', $classes);

        //item
        $this->add_render_attribute('item', 'class', [
            'chk-testimonial-1',
            $settings['testi_style'],
            'pos-relative d-flex flex-col w-full h-full overflow-hidden transition-all z-1',
        ]);
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?> dir="<?php echo $data_rtl; ?>">
                <div class="swiper-content-inner">
                    <div class="init-carousel-swiper swiper" data-carousel="<?php echo Chakavak_Controls_Elementor::get_carousel_settings($this); ?>">
                        <div class="swiper-wrapper">
                            <?php
                            $name_tag = $settings['name_tag'];
                            foreach ($settings['testimonials'] as $item) {
                                echo '<div class="swiper-slide">';
                                include CHAKAVAK_ELEMENTOR_DIR . 'widgets/layouts/testimonials-group-1/item-' . $settings['testi_style'] . '.php';
                                echo '</div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <?php echo($settings['ca_pagination'] ? '<div class="swiper-pagination"></div>' : ''); ?>
                <?php echo($settings['ca_navigation'] ? '<div class="swiper-nav-next"></div><div class="swiper-nav-prev"></div>' : ''); ?>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Testimonails_Carousel_1());
