<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Team Carousel 1
 */
class Chakavak_Team_Carousel_1 extends Widget_Base
{
    const NAME = 'chk_team_carousel_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Team Carousel 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-carousel';
    }

    public function get_keywords()
    {
        return ['team', 'person', 'carousel', __('team', 'chakavak')];
    }

    public function get_style_depends()
    {
        return [
            'swiper-bundle',
            'chk-team-1'
        ];
    }

    public function get_script_depends()
    {
        return [
            'swiper-bundle',
            'chk-widgets'
        ];
    }

    protected function register_controls()
    {
        /**TAB_CONTENT**/
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Member Teams', 'chakavak'),
            ]
        );

        $this->add_control(
            'team_style',
            [
                'label' => esc_html__('Display Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 's1',
                'options' => [
                    's1' => esc_html__('Style 1', 'chakavak'),
                    's2' => esc_html__('Style 2', 'chakavak'),
                    's3' => esc_html__('Style 3', 'chakavak'),
                ]
            ]
        );

        $repeater = new Repeater();


        Chakavak_Controls_Elementor::select_image($repeater, 'photo', null);

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => esc_html__('Peter Perish', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'extra',
            [
                'label' => esc_html__('Extra/Job', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => esc_html__('co-founder of company', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link To Details', 'chakavak'),
                'type' => Controls_Manager::URL,
                'placeholder' => 'https://',
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        /* Social */

        $repeater->add_control(
            'heading_social',
            [
                'label' => __('Social Network', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $repeater->add_control(
            'sw_social_icons',
            [
                'label' => esc_html__('Social Icons', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => esc_html__('Yes', 'chakavak'),
                'label_off' => esc_html__('No', 'chakavak'),
                'return_value' => 'yes',
            ]
        );

        //1
        $repeater->add_control(
            'social_icon1',
            [
                'label' => esc_html__('Social Icon #1', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'separator' => 'before',
                //'skin'      => 'inline',
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'default' => [
                    'value' => 'ti ti-logo-twitter',
                    'library' => 'theme-icons',
                ]
            ]
        );

        $repeater->add_control(
            'social_link1',
            [
                'label' => esc_html__('Social Link #1', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        //2
        $repeater->add_control(
            'social_icon2',
            [
                'label' => esc_html__('Social Icon #2', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'separator' => 'before',
                //'skin'      => 'inline',
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'default' => [
                    'value' => 'ti ti-logo-facebook',
                    'library' => 'theme-icons',
                ]
            ]
        );

        $repeater->add_control(
            'social_link2',
            [
                'label' => esc_html__('Social Link #2', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        //3
        $repeater->add_control(
            'social_icon3',
            [
                'label' => esc_html__('Social Icon #3', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'separator' => 'before',
                //'skin'      => 'inline',
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'default' => [
                    'value' => 'ti ti-logo-instagram',
                    'library' => 'theme-icons',
                ]
            ]
        );

        $repeater->add_control(
            'social_link3',
            [
                'label' => esc_html__('Social Link #3', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        //4
        $repeater->add_control(
            'social_icon4',
            [
                'label' => esc_html__('Social Icon #4', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'separator' => 'before',
                //'skin'      => 'inline',
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'default' => [
                    'value' => 'ti ti-logo-linkedin',
                    'library' => 'theme-icons',
                ]
            ]
        );

        $repeater->add_control(
            'social_link4',
            [
                'label' => esc_html__('Social Link #4', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'sw_social_icons' => 'yes',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'team_items',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{name}}}',
                'default' => [
                    [
                        'name' => esc_html__('Mohammad Reza Ahmadi', 'chakavak'),
                        'extra' => esc_html__('co-founder of company', 'chakavak'),
                        'link' => [
                            'url' => '#'
                        ],
                        'social_icon1' => [
                            'value' => 'ti ti-logo-twitter',
                            'library' => 'theme-icons',
                        ],
                        'social_link1' => '#',
                        'social_icon2' => [
                            'value' => 'ti ti-logo-facebook',
                            'library' => 'theme-icons',
                        ],
                        'social_link2' => '#',
                        'social_icon3' => [
                            'value' => 'ti ti-logo-instagram',
                            'library' => 'theme-icons',
                        ],
                        'social_link3' => '#',
                        'social_icon4' => [
                            'value' => 'ti ti-logo-linkedin',
                            'library' => 'theme-icons',
                        ],
                        'social_link4' => '#',

                    ],
                ],
            ]
        );

        Chakavak_Controls_Elementor::image_size($this, 'thumbnail', null, 'full', 'none');

        Chakavak_Controls_Elementor::element_tag($this, 'name_tag', esc_html__('Name Tag', 'chakavak'), 'h4');

        $this->end_controls_section();

        Chakavak_Controls_Elementor::add_control_carousel($this, false);

        /**TAB_STYLE**/
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 2,
                                'vertical' => 3,
                                'blur' => 10,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.12)'
                            ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-team-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('Border', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-team-1',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => esc_html__('Item Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-team-1',
                'separator' => 'before',
            ]
        );


        $this->end_controls_section();

        //photo
        $this->start_controls_section(
            'photo_style',
            [
                'label' => esc_html__('Photo', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'photo_space',
            [
                'label' => esc_html__('Spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'team_style!' => 's2',
                ]
            ]
        );

        $this->add_responsive_control(
            'photo_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1:not(.s3) .chk-team-1__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'team_style!' => 's3',
                ]
            ]
        );

        $this->add_responsive_control(
            'photo_radius_s3',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => '0',
                        'max' => '30',
                        'step' => '1',
                    ],
                    '%' => [
                        'min' => '0',
                        'max' => '30',
                        'step' => '1',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'team_style' => 's3',
                ]
            ]
        );

        $this->add_control(
            'photo_hover_effect',
            [
                'label' => esc_html__('Hover Effect', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'chakavak'),
                    'zoom' => esc_html__('Zoom', 'chakavak'),
                    'grayscale' => esc_html__('Grayscale', 'chakavak')
                ],
            ]
        );

        $this->end_controls_section();

        //info
        $this->start_controls_section(
            'info_style',
            [
                'label' => esc_html__('Info item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__info' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        /* title */
        $this->add_control(
            'name_heading',
            [
                'label' => __('Name', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'name_space',
            [
                'label' => esc_html__('Spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__name' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .chk-team-1__name',
                'exclude' => [
                    'font_style',
                    'text_decoration',
                    'word_spacing',
                ],
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Name color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'name_hover_color',
            [
                'label' => esc_html__('Name color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__name a:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        /* extra */
        $this->add_control(
            'extra_heading',
            [
                'label' => __('Extra / Position', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'extra_typography',
                'selector' => '{{WRAPPER}} .chk-team-1__extra',
                'exclude' => [
                    'font_style',
                    'text_decoration',
                    'word_spacing',
                ],
            ]
        );

        $this->add_control(
            'extra_color',
            [
                'label' => esc_html__('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__extra' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //social

        $this->start_controls_section(
            'socials_style',
            [
                'label' => esc_html__('Socials', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'socials_align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors_dictionary' => [
                    'left' => 'flex-end',
                    'right' => 'flex-start',
                    'center' => 'center',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1.s1 .chk-team-1__social' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'socials_space',
            [
                'label' => esc_html__('Space between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1.s1 .chk-team-1__social' => 'column-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-team-1.s2 .chk-team-1__social' => 'row-gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'socials_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social .chk-team-1__social-toggle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'togggle_heading',
            [
                'label' => __('Toggle button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'team_style' => 's3'
                ],
            ]
        );
        //toggle style tab
        $this->start_controls_tabs(
            'socials_toggle_tabs',
            [
                'condition' => [
                    'team_style' => 's3'
                ],
            ]
        );

        $this->start_controls_tab(
            'social_toogle_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );


        $this->add_control(
            'socials_toggle_color_normal',
            [
                'label' => esc_html__('Toggle icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social .chk-team-1__social-toggle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'socials_toggle_bgcolor_normal',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html_x('Toggle background color', 'Background Control', 'elementor'),
                    ]
                ],
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social .chk-team-1__social-toggle',

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'social_toogle_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'socials_toggle_color_hover',
            [
                'label' => esc_html__('Toggle icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social-toggle:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social.active .chk-team-1__social-toggle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'socials_toggle_bgcolor_hover',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html_x('Toggle background color', 'Background toggle Control', 'elementor'),
                    ]
                ],
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-team-1.s3 .chk-team-1__social-toggle:before',
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        //icon social
        $this->start_controls_tabs(
            'socials_tabs',
            [
                'separator' => 'before',
            ]
        );

        $this->start_controls_tab(
            'social_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'social_color_normal',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a:not(:hover,:focus)' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-team-1__social a:not(:hover,:focus) svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_border_normal',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a:not(:hover,:focus)' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style!' => 's3'
                ]
            ]
        );

        $this->add_control(
            'social_bg_normal',
            [
                'label' => esc_html__('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a:not(:hover,:focus)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();


        $this->start_controls_tab(
            'social_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'social_color_hover',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a:is(:hover,:focus)' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-team-1__social a:is(:hover,:focus) svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_border_hover',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a:is(:hover,:focus)' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'team_style!' => 's3'
                ]
            ]
        );

        $this->add_control(
            'social_bg_hover',
            [
                'label' => esc_html__('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-team-1__social a:is(:hover,:focus)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        Chakavak_Controls_Elementor::style_nav_carousel($this, ['ca_navigation' => 'yes']);
        Chakavak_Controls_Elementor::style_dots_carousel($this, ['ca_pagination' => 'yes']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $data_rtl = is_rtl() ? 'rtl' : 'ltr';
        $classes = [];
        $classes[] = 'chk-team-group-1 chk-team-carousel-1';
        $this->add_render_attribute('wrapper', 'class', $classes);
        $style = $settings['team_style'];
        $this->add_render_attribute('item', 'class', [
            'chk-team-1',
            $style,
            'chk-img-hover-' . $settings['photo_hover_effect'],
            'pos-relative z-1 w-full overflow-hidden transition-all z-1',
        ]);
        $this->add_render_attribute('team-info', 'class', 'chk-team-1__info transition-all');

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?> dir="<?php echo $data_rtl; ?>">
                <div class="swiper-content-inner">
                    <div class="init-carousel-swiper swiper" data-carousel="<?php echo Chakavak_Controls_Elementor::get_carousel_settings($this); ?>">
                        <div class="swiper-wrapper">
                            <?php
                            $inumber = 1;
                            foreach ($settings['team_items'] as $item) {

                                if ($settings['thumbnail_size'] == 'full') {
                                    $imageTagHtml = wp_get_attachment_image($item['photo']['id'], 'full');
                                } else {
                                    $imgUrl = Group_Control_Image_Size::get_attachment_image_src($item['photo']['id'], 'thumbnail', $settings);
                                    if (!$imgUrl) {
                                        $imgUrl = $item['photo']['url'];
                                    }
                                    $imageTagHtml = '<img src="' . esc_url($imgUrl) . '" alt="photo-' . $inumber . '" />';
                                }

                                echo '<div class="swiper-slide">';
                                include CHAKAVAK_ELEMENTOR_DIR . 'widgets/layouts/team-group-1/item-' . $style . '.php';
                                echo '</div>';
                                $inumber++;
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <?php echo($settings['ca_pagination'] ? '<div class="swiper-pagination"></div>' : ''); ?>
                <?php echo($settings['ca_navigation'] ? '<div class="swiper-nav-next"></div><div class="swiper-nav-prev"></div>' : ''); ?>

            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Team_Carousel_1());
