<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Tabs 1
 */
class Chakavak_Tabs_1 extends Widget_Base
{
    const NAME = 'chk_tabs_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Tabs 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-tabs';
    }

    public function get_keywords()
    {
        return ['tabs', esc_html__('tab', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-tabs-1'];
    }

    public function get_script_depends()
    {
        return [
            'chk-widgets',
        ];
    }

    protected function register_controls()
    {

        /**TAB_CONTENT**/
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Items', 'chakavak'),
            ]
        );


        $repeater = new Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => esc_html__('Icon Type', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    'none' => [
                        'title' => esc_html__('None', 'chakavak'),
                        'icon' => 'eicon-ban',
                    ],
                    'icon' => [
                        'title' => esc_html__('Icon', 'chakavak'),
                        'icon' => 'eicon-star',
                    ],
                    'image' => [
                        'title' => esc_html__('Image', 'chakavak'),
                        'icon' => 'eicon-image',
                    ],
                ],
                'default' => 'icon',
            ]
        );

        $repeater->add_control(
            'select_icon',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [],
                'fa4compatibility' => 'icon',
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $repeater->add_control(
            'select_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => get_template_directory_uri() . '/inc/elementor/assets/images/placeholder.webp',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Tab Title', 'chakavak'),
                'placeholder' => __('Tab Title', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'content_type',
            [
                'label' => esc_html__('Content Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'text' => esc_html__('Text', 'chakavak'),
                    'text_image' => esc_html__('Text & Image', 'chakavak'),
                    'templates' => esc_html__('Saved Templates', 'chakavak'),
                ],
                'default' => 'text',
            ]
        );

        $repeater->add_control(
            'content_templates',
            [
                'label' => esc_html__('Choose Template', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => Chakavak_Controls_Elementor::get_page_template_options(),
                'condition' => [
                    'content_type' => 'templates',
                ],
            ]
        );

        $repeater->add_control(
            'content_text',
            [
                'label' => __('Description', 'chakavak'),
                'default' => __('Lorem ipsum dolor sit amet consectetur adipisicing elit temporibus sunt magni aperiam atex recusandae inventore molestiae scepturi deleniti numquam', 'chakavak'),
                'placeholder' => __('Enter text content', 'chakavak'),
                'type' => Controls_Manager::WYSIWYG,
                'show_label' => true,
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'content_type',
                            'operator' => '==',
                            'value' => 'text',
                        ],
                        [
                            'name' => 'content_type',
                            'operator' => '==',
                            'value' => 'text_image',
                        ],
                    ],
                ],
            ]
        );

        Chakavak_Controls_Elementor::select_image($repeater, 'content_image', __('Select image', 'chakavak'), ['content_type' => 'text_image']);

        Chakavak_Controls_Elementor::image_size($repeater, 'image', __('Image size', 'chakavak'), 'full', 'none', ['content_type' => 'text_image']);

        $repeater->add_control(
            'image_position',
            [
                'label' => __('Image position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'order-xs-last',
                'options' => [
                    'order-xs-first' => [
                        'title' => __('First', 'chakavak'),
                        'icon' => 'eicon-h-align-right',
                    ],
                    'order-xs-last' => [
                        'title' => __('Last', 'chakavak'),
                        'icon' => 'eicon-h-align-left',
                    ],
                ],
                'condition' => [
                    'content_type' => 'text_image',
                ]
            ]
        );


        $repeater->add_responsive_control(
            'content_vertical_alignment',
            [
                'label' => __('Content alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Top', 'chakavak'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'chakavak'),
                        'icon' => 'eicon-v-align-middle',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Bottom', 'chakavak'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} ' => 'align-items: {{VALUE}};',
                ],
                'condition' => [
                    'content_type' => 'text_image',
                ]
            ]
        );

        $this->add_control(
            'tab_items',
            [
                'label' => __('Items', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Tab Title #1', 'chakavak'),
                    ],
                    [
                        'title' => __('Tab Title #2', 'chakavak'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'tabs_style',
            [
                'label' => __('Tabs Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'basic' => __('Basic', 'chakavak'),
                    'pills' => __('Pills', 'chakavak'),
                ],
                'default' => 'basic',
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label' => __('Icon Position', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'block' => __('Block', 'chakavak'),
                    'inline' => __('Inline', 'chakavak'),
                ],
                'default' => 'inline',
            ]
        );

        $this->end_controls_section();

        //item
        $this->start_controls_section(
            'item_style',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-tabs-1',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background', 'chakavak'),
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-tabs-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .chk-tabs-1',
            ]
        );

        $this->end_controls_section();

        //nav style
        $this->start_controls_section(
            'nav_style',
            [
                'label' => __('Nav Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'nav_align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors_dictionary' => [
                    'left' => 'flex-end',
                    'right' => 'flex-start',
                    'center' => 'center',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_space_between',
            [
                'label' => __('Spacing between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'nav_typography',
                'exclude' => [
                    'font_style',
                    'text_decoration',
                    'word_spacing',
                ],
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-link',
            ]
        );

        $this->add_responsive_control(
            'nav_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'tabs_style!' => 'basic'
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_border_width',
            [
                'label' => esc_html__('Border width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-basic .chk-tabs-1__nav-link:before' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_nav_style');

        //normal
        $this->start_controls_tab(
            'nav_normal',
            [
                'label' => __('Normal', 'chakavak')
            ]
        );

        $this->add_control(
            'nav_color_normal',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_border_color_normal',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-basic .chk-tabs-1__nav-link' => 'border-bottom-color: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link' => 'border-color: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'nav_background_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background', 'chakavak'),
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link',
                'condition' => [
                    'tabs_style' => 'pills'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'nav_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link',
                'condition' => [
                    'tabs_style' => 'pills'
                ],
            ]
        );

        $this->end_controls_tab();

        //hover
        $this->start_controls_tab(
            'nav_hover',
            [
                'label' => __('Hover', 'chakavak')
            ]
        );

        $this->add_control(
            'nav_color_hover',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_border_color_hover',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-basic .chk-tabs-1__nav-link:is(:hover,:focus)' => 'border-bottom-color: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link:is(:hover,:focus)' => 'border-color: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'nav_background_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background', 'chakavak'),
                        'default' => 'classic',
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link:before',
                'condition' => [
                    'tabs_style' => 'pills'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'nav_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-pills .chk-tabs-1__nav-link:is(:hover,:focus)',
                'condition' => [
                    'tabs_style' => 'pills'
                ],
            ]
        );

        $this->end_controls_tab();

        //active
        $this->start_controls_tab(
            'nav_active',
            [
                'label' => __('Active', 'chakavak')
            ]
        );

        $this->add_control(
            'nav_color_active',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav li.current .chk-tabs-1__nav-link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_border_color_active',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-basic li.current .chk-tabs-1__nav-link' => 'border-bottom-color: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-pills li.current .chk-tabs-1__nav-link' => 'border-color: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'nav_background_active',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background', 'chakavak'),
                        'default' => 'classic',
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-pills li.current .chk-tabs-1__nav-link:before',
                'condition' => [
                    'tabs_style' => 'pills'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'nav_shadow_active',
                'selector' => '{{WRAPPER}} .chk-tabs-1__nav-pills li.current .chk-tabs-1__nav-link',
                'condition' => [
                    'tabs_style' => 'pills'
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        //icon
        $this->add_control(
            'icon_style',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 30,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-link svg' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-link img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_spacing',
            [
                'label' => __('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 30,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link.chk-icon-block .chk-tabs-1__nav-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    'body:not(.rtl) {{WRAPPER}} .chk-tabs-1__nav-link.chk-icon-inline .chk-tabs-1__nav-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .chk-tabs-1__nav-link.chk-icon-inline .chk-tabs-1__nav-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        /*tabs*/
        $this->start_controls_tabs('icon_tab_style');
        //normal
        $this->start_controls_tab(
            'icon_normal',
            [
                'label' => __('Normal', 'chakavak')
            ]
        );

        $this->add_control(
            'icon_color_normal',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-link svg' => 'fill:  {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        //hover
        $this->start_controls_tab(
            'icon_hover',
            [
                'label' => __('Hover', 'chakavak')
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav-link:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-tabs-1__nav-link:hover svg' => 'fill:  {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        //active
        $this->start_controls_tab(
            'icon_active',
            [
                'label' => __('Active', 'chakavak')
            ]
        );

        $this->add_control(
            'icon_color_active',
            [
                'label' => __('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__nav li.current .chk-tabs-1__nav-link i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-tabs-1__nav li.current .chk-tabs-1__nav-link svg' => 'fill:  {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        /*Content Style */
        $this->start_controls_section(
            'content_style',
            [
                'label' => __('Content Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_space_top',
            [
                'label' => __('Spacing top', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-wrap' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-wrap',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'color' => [
                        'default' => 'var(--chk-c-gray-200)',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                            'isLinked' => true,
                        ]
                    ],
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'content_bg',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Background', 'chakavak'),
                        'default' => 'classic',
                    ],
                    'color' => [
                        'default' => 'var(--chk-c-gray-50)',
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-wrap',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_shadow',
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-wrap',
            ]
        );

        $this->add_control(
            'content_text_style',
            [
                'label' => __('Text style', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'text_a_color',
            [
                'label' => __('link color in paragraphs', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'description' => __('Color of anchor (link) text within paragraphs', 'chakavak'),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor p > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'text_a_color_hover',
            [
                'label' => __('link color hover in paragraphs', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'description' => __('Hover color of anchor (link) text within paragraphs', 'chakavak'),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor p > a:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_tag_color',
            [
                'label' => esc_html__('Heading tag color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor :is(h1,h2,h3,h4,h5,h6)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h1_typography',
                'label' => __('H1 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor h1',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h2_typography',
                'label' => __('H2 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor h2',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h3_typography',
                'label' => __('H3 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor h3',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h4_typography',
                'label' => __('H4 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor h4',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h5_typography',
                'label' => __('H5 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor h5',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h6_typography',
                'label' => __('H6 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-tabs-1__content-text .chk-classic-editor h6',
            ]
        );

        $this->add_control(
            'content_image_style',
            [
                'label' => __('Image style', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image_content_description',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => __('style changes when content type is set to \'Text & Image\'', 'chakavak'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info'
            ]
        );

        $this->add_responsive_control(
            'image_content_width',
            [
                'label' => __('Image Width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 2000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__image-wrap img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'description' => esc_html__('NOTE:The height is created automatically according to the width of the image.', 'chakavak'),
            ]
        );


        $this->add_responsive_control(
            'image_align',
            [
                'label' => __('Image alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors_dictionary' => [
                    'left' => 'flex-end',
                    'right' => 'flex-start',
                    'center' => 'center',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__image-wrap' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'text_image_radius',
            [
                'label' => __('Image border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-tabs-1__image-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'label' => esc_html__('Image shadow', 'chakavak'),
                'name' => 'text_image_shadow',
                'selector' => '{{WRAPPER}} .chk-tabs-1__image-wrap img',
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        if (empty($settings['tab_items'])) {
            return;
        }
        $this->add_render_attribute(
            'wrapper',
            'class',
            [
                'chk-tabs-1',
            ]
        );
        $this->add_render_attribute(
            'tab_nav',
            'class',
            [
                'chk-tabs-1__nav',
                'list-none',
                'pos-relative',
                'd-flex',
                'z-1 p-0 m-0',
                'chk-tabs-1__nav-' . $settings['tabs_style']
            ]
        );
        $random = rand(1, 1000);
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php $this->print_render_attribute_string('wrapper'); ?>>
                <ul <?php $this->print_render_attribute_string('tab_nav'); ?>>
                    <?php
                    $i = 1;
                    $icon_position = 'chk-icon-' . $settings['icon_position'];
                    $style_link = $settings['tabs_style'] === 'pills' ? 'chk-bg-before' : '';
                    foreach ($settings['tab_items'] as $item) :
                        echo '<li class="chk-tabs-1__nav-item" data-tab="tab-' . esc_attr($i . $random) . '">';
                        echo '<a class="chk-tabs-1__nav-link d-inline-flex pos-relative z-1 cursor-pointer transition-all ' . $icon_position . ' ' . $style_link . '">';
                        if ($item['icon_type'] === 'icon') {
                            echo '<span class="chk-tabs-1__nav-icon lh-0 pos-relative z-1">';
                            Icons_Manager::render_icon($item['select_icon'], ['aria-hidden' => 'true']);
                            echo '</span>';
                        } elseif ($item['icon_type'] === 'image') {
                            echo '<span class="chk-tabs-1__nav-icon lh-0 pos-relative z-1 lh-1">';
                            $imageTagHtml = wp_get_attachment_image($item['select_image']['id'], 'full', "", ["alt" => esc_attr(get_post_meta($item['select_image']['id'], '_wp_attachment_image_alt', true))]);
                            echo $imageTagHtml;
                            echo '</span>';
                        }
                        echo '<span class="pos-relative z-1">' . esc_html($item['title']) . '</span>';
                        echo '</a>';
                        echo '</li>';
                        $i++;
                    endforeach;
                    ?>
                </ul>

                <div class="chk-tabs-1__content-wrap pos-relative z-1">
                    <?php
                    $j = 1;
                    foreach ($settings['tab_items'] as $item) :
                        echo '<div id="tab-' . esc_attr($j . $random) . '" class="chk-tabs-1__content pos-relative z-1">';
                        if ($item['content_type'] == 'text') {
                            echo '<div class="chk-tabs-1__content-text"><div class="chk-classic-editor">' . do_shortcode($item['content_text']) . '</div></div>';
                        } elseif ($item['content_type'] == 'text_image') {
                            $grid = 'chk-tabs-1__content-multi pos-relative z-1' . (!empty($item['content_image']['id']) ? ' row row-cols-xs-1 row-cols-lg-2' : ' row-cols-sm-1');
                            echo '<div class="pos-relative z-1 elementor-repeater-item-' . $item['_id'] . ' ' . $grid
                                . '">';
                            if (!empty($item['content_image']['id'])) {
                                $image_alt = get_post_meta($item['content_image']['id'], '_wp_attachment_image_alt', true);
                                $image_html = wp_get_attachment_image(
                                    $item['content_image']['id'],
                                    $item['image_size'],
                                    false,
                                    [
                                        'class' => 'd-block w-full h-auto',
                                        'alt' => $image_alt
                                    ]
                                );
                                echo '<div class="chk-tabs-1__image-wrap w-full pos-relative ' . $item['image_position'] . '">' . $image_html . '</div>';
                            }
                            echo '<div class="chk-tabs-1__text-wrap w-full pos-relative chk-tabs-1__content-text"><div class="chk-classic-editor">' . do_shortcode($item['content_text']) . '</div></div>';
                            echo '</div>';
                        } elseif ($item['content_type'] == 'templates') {
                            if (!empty($item['content_templates'])) {
                                $template_id = $item['content_templates'];
                                $frontend = new Frontend;
                                echo $frontend->get_builder_content($template_id, true);
                            }
                        }
                        echo '</div>';
                        $j++;
                    endforeach;
                    ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Tabs_1());
