<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Social icons
 */
class chakavak_Social_Icons extends Widget_Base
{
    const NAME = 'chk_social_icons';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Social Icons', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-social-icons';
    }

    public function get_keywords()
    {
        return ['social', 'icons', 'link', __('social icons', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_social_icon',
            [
                'label' => esc_html__('Social Icons', 'chakavak'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'social',
                'default' => [
                    'value' => 'ti ti-logo-instagram',
                    'library' => 'chakavak-theme-icons',
                ],
                'recommended' => [
                    'chakavak-theme-icons' => [
                        'logo-aparat',
                        'logo-behance',
                        'logo-dribbble',
                        'logo-facebook',
                        'logo-gmail',
                        'logo-instagram',
                        'logo-linkedin',
                        'logo-pinterest',
                        'logo-skype',
                        'logo-spotify',
                        'logo-telegram',
                        'logo-twitter',
                        'logo-whatsapp',
                        'logo-x',
                        'logo-youtube',
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'is_external' => 'true',
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'item_icon_bg_color',
            [
                'label' => esc_html__('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'item_icon_color',
            [
                'label' => esc_html__('Icon Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_icon_list',
            [
                'label' => esc_html__('Social Icons', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# var migrated = "undefined" !== typeof __fa4_migrated, social = ( "undefined" === typeof social ) ? false : social; #>{{{ elementor.helpers.getSocialNetworkNameFromIcon( social_icon, social, true, migrated, true ) }}}',
                'default' => [
                    [
                        'social_icon' => [
                            'value' => 'ti ti-logo-facebook',
                            'library' => 'chakavak-theme-icons',
                        ],
                    ],
                    [
                        'social_icon' => [
                            'value' => 'ti ti-logo-twitter',
                            'library' => 'chakavak-theme-icons',
                        ],
                    ],
                    [
                        'social_icon' => [
                            'value' => 'ti ti-logo-instagram',
                            'library' => 'chakavak-theme-icons',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'shape',
            [
                'label' => esc_html__('Shape', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'rounded',
                'options' => [
                    'square' => esc_html__('Square', 'chakavak'),
                    'rounded' => esc_html__('Rounded', 'chakavak'),
                    'circle' => esc_html__('Circle', 'chakavak'),
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors_dictionary' => [
                    'left' => 'flex-end',
                    'right' => 'flex-start',
                    'center' => 'center',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_social_style',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'vw'],
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons__item' => '--icon-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons__item' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_spacing',
            [
                'label' => esc_html__('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'default' => [
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons' => '--gap: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .chk-social-icons__item',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label' => esc_html__('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons__item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bgcolor',
            [
                'label' => esc_html__('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons__item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-social-icons__item' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-social-icons d-flex flex-wrap">
                <?php foreach ($settings['social_icon_list'] as $item) :
                    $name_icon = \Chakavak_Controls_Elementor::get_icon_name($item['social_icon']);
                    $classes = [
                        'chk-social-icons__item',
                        'if-center',
                        'pos-relative',
                        'chk-shape-' . $settings['shape'],
                        'elementor-repeater-item-' . $item['_id'],
                        'z-1',
                        'lh-1',
                        'overflow-hidden',
                        'transition-all',
                    ];
                    $item_cls = implode(' ', $classes);
                    if (!empty($item['link']['url'])) {
                        \Chakavak_Controls_Elementor::render_start_link($this, $item['link'], $item_cls);
                        echo '<span class="elementor-screen-only">' . esc_html($name_icon) . '</span>';
                        Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true']);
                        \Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                    } else {
                        echo '<span class="' . $item_cls . '">';
                        echo '<span class="elementor-screen-only">' . esc_html($name_icon) . '</span>';
                        Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true']);
                        echo '</span>';
                    }
                endforeach; ?>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new chakavak_Social_Icons());
