<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: price table 1
 */
class Chakavak_Pric_Table_1 extends Widget_Base
{
    const NAME = 'chk_price_table_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Price Table 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-price-table';
    }

    public function get_keywords()
    {
        return ['pricing', 'price', 'money', __('price table', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-price-table-1'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
            ]
        );

        //title
        $this->add_control(
            'price_title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Standard Plan', 'chakavak'),
            ]
        );

        Chakavak_Controls_Elementor::element_tag($this, 'title_tag', __('Title tag', 'chakavak'), 'h3', ['price_title!' => '']);

        $this->add_control(
            'price_subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('For small business', 'chakavak'),
            ]
        );

        $this->add_control(
            'price_info',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '4',
                'dynamic' => [
                    'active' => true,
                ],
                'default' => esc_html__('Comprehensive and practical digital marketing solutions in the Standard Plan to grow your business.', 'chakavak'),
            ]
        );

        //pricing
        $this->add_control(
            'heading_price',
            [
                'label' => __('Price', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'price_prefix',
            [
                'label' => esc_html__('prefix', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('/ MO', 'chakavak'),
            ]
        );

        $this->add_control(
            'price_amount',
            [
                'label' => __('Amount', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('45', 'chakavak'),
            ]
        );

        $this->add_control(
            'currency_symbol',
            [
                'label' => __('Currency Symbol', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => array(
                    'active' => true,
                ),
                'label_block' => true,
                'default' => __('$', 'chakavak'),
            ]
        );

        $this->add_control(
            'currency_symbol_position',
            [
                'label' => esc_html__('Currency Symbol position', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'before' => esc_html__('Before Price', 'chakavak'),
                    'after' => esc_html__('After Price', 'chakavak')
                ],
                'default' => 'before',
                'condition' => [
                    'currency_symbol!' => '',
                ],
            ]
        );

        $this->add_control(
            'heading_button',
            [
                'label' => __('Button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'button_sw',
            [
                'label' => __('Show Button', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __('OFF', 'chakavak'),
                'label_on' => __('ON', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => esc_html__('Button Text', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => esc_html__('Get Started', 'chakavak'),
                'condition' => [
                    'button_sw' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'button_link',
            [
                'label' => esc_html__('Link', 'chakavak'),
                'label_block' => false,
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://www.your-link.com',
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'button_sw' => 'yes',
                ]
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => esc_html__('Background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-table-price-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'exclude' => ['color'],
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                            'isLinked' => true,
                        ]
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-table-price-1',
            ]
        );

        $this->start_controls_tabs('item_tabs');

        $this->start_controls_tab(
            'item_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'item_border_color',
            [
                'label' => __('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1' => 'border-color:{{VALUE}}',
                ],
                'default' => 'var(--chk-c-gray-300)',
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'item_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'fields_options' => [
                    'box_shadow_type' =>
                    [
                        'default' => 'yes'
                    ],
                    'box_shadow' => [
                        'default' =>
                        [
                            'horizontal' => 0,
                            'vertical' => 0,
                            'blur' => 5,
                            'spread' => 0,
                            'color' => 'rgba(0,0,0,0.05)'
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-table-price-1',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'item_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'item_border_color_hover',
            [
                'label' => __('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1:hover' => 'border-color:{{VALUE}}',
                ],
                'default' => 'var(--chk-c-primary)',
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'item_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'fields_options' => [
                    'box_shadow_type' =>
                    [
                        'default' => 'yes'
                    ],
                    'box_shadow' => [
                        'default' =>
                        [
                            'horizontal' => 0,
                            'vertical' => 2,
                            'blur' => 10,
                            'spread' => 0,
                            'color' => 'rgba(28, 29, 34, 0.16)'
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-table-price-1:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        /*** Header price table */
        $this->start_controls_section(
            'content_style',
            [
                'label' => __('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        //headline
        $this->add_control(
            'headline_head',
            [
                'label' => __('Headline', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'headline_align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__heading' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'headline_space_bottom',
            [
                'label' => esc_html__('Margin Bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_head',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'price_title!' => '',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-table-price-1__title',
                'condition' => [
                    'price_title!' => '',
                ]
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__title' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'price_title!' => '',
                ]
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__title a:is(:hover,:focus)' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'button_link[url]!' => '',
                    'price_title!' => '',
                ]
            ]
        );

        $this->add_responsive_control(
            'title_space_bottom',
            [
                'label' => esc_html__('Spacing Bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_head',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'price_subtitle!' => '',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-table-price-1__subtitle',
                'condition' => [
                    'price_subtitle!' => '',
                ]
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__subtitle' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'price_subtitle!' => '',
                ]
            ]
        );

        $this->add_control(
            'desc_head',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'price_info!' => '',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'exclude' => [],
                'selector' => '{{WRAPPER}} .chk-table-price-1__desc',
            ]
        );

        $this->add_responsive_control(
            'desc_align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__desc' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__desc' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'price_info!' => '',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'desc_background',
                'label' => esc_html__('Background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-table-price-1__desc',
                'condition' => [
                    'price_info!' => '',
                ]
            ]
        );

        $this->add_responsive_control(
            'desc_radius',
            [
                'label' => esc_html__('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__desc' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'price_info!' => '',
                ]
            ]
        );

        $this->add_responsive_control(
            'desc_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'price_info!' => '',
                ]
            ]
        );

        $this->end_controls_section();

        /*** PRICE */
        $this->start_controls_section(
            'price_style',
            [
                'label' => __('Price', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'price_amount!' => ''
                ]
            ]
        );

        $this->add_responsive_control(
            'price_space_top',
            [
                'label' => esc_html__('Spacing top & bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__price' => 'margin-top: {{SIZE}}{{UNIT}};margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors_dictionary' => [
                    'left' => 'flex-end',
                    'right' => 'flex-start',
                    'center' => 'center',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__price' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'price_prefix' => ''
                ]
            ]
        );

        $this->add_control(
            'price_prefix_heading',
            [
                'label' => __('Prefix', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'price_prefix!' => ''
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_prefix_typography',
                'selector' => '{{WRAPPER}} .chk-table-price-1__prefix',
                'condition' => [
                    'price_prefix!' => ''
                ]
            ]
        );

        $this->add_control(
            'price_prefix_color',
            [
                'label' => __('Prefix color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__prefix' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'price_prefix!' => ''
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'price_prefix_text_shadow',
                'selector' => '{{WRAPPER}} .chk-table-price-1__prefix',
                'condition' => [
                    'price_prefix!' => ''
                ]
            ]
        );

        $this->add_control(
            'price_amount_heading',
            [
                'label' => __('Amount', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_amount_typography',
                'selector' => '{{WRAPPER}} .chk-table-price-1__number',
            ]
        );

        $this->add_control(
            'price_amount_color',
            [
                'label' => __('Prefix color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__number' => 'color:{{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'price_number_text_shadow',
                'selector' => '{{WRAPPER}} .chk-table-price-1__number',
            ]
        );

        $this->add_control(
            'price_currency_heading',
            [
                'label' => __('Currency', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'currency_symbol!' => ''
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_currency_typography',
                'selector' => '{{WRAPPER}} .chk-table-price-1__currency',
                'condition' => [
                    'currency_symbol!' => ''
                ],
            ]
        );

        $this->add_control(
            'price_currency_color',
            [
                'label' => __('Currency color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__currency' => 'color:{{VALUE}}',
                ],
                'condition' => [
                    'currency_symbol!' => ''
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'price_currency_text_shadow',
                'selector' => '{{WRAPPER}} .chk-table-price-1__currency',
                'condition' => [
                    'currency_symbol!' => ''
                ],
            ]
        );

        $this->end_controls_section();

        /* Button ****/
        $this->start_controls_section(
            'pric_button_style',
            [
                'label' => __('Button', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_sw' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'button_width',
            [
                'label' => __('Button Width', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'w-full',
                'options' => [
                    'w-auto' => __('Auto', 'chakavak'),
                    'w-full' => __('Full width', 'chakavak'),
                ],
            ]
        );

        $this->add_responsive_control(
            'button_align',
            [
                'label' => esc_html__('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'button_width!' => 'w-full',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'exclude' => [],
                'selector' => '{{WRAPPER}} .chk-table-price-1__button .chk-button',
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_button');

        $this->start_controls_tab(
            'button_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_color_normal',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_normal',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color_normal',
            [
                'label' => esc_html__('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-table-price-1__button .chk-button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button:is(:hover,:focus)' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button:is(:hover,:focus)' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-table-price-1__button .chk-button:is(:hover,:focus)' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-table-price-1__button .chk-button:is(:hover,:focus)',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element d-flex flex-col h-full">
            <div class="chk-table-price-1 d-flex flex-col h-full">

                <div class="chk-table-price-1__heading">
                    <?php if (!empty($settings['price_title'])) {
                        $this->add_render_attribute('title', 'class', 'chk-table-price-1__title');
                        echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                        Chakavak_Controls_Elementor::render_start_link($this, $settings['button_link'], 'd-block');
                        echo wp_kses_post($settings['price_title']);
                        Chakavak_Controls_Elementor::render_end_link($this, $settings['button_link']);
                        echo '</' . $settings['title_tag'] . '>';
                    } ?>

                    <?php if (!empty($settings['price_subtitle'])) {
                        $this->add_render_attribute('subtitle', 'class', 'chk-table-price-1__subtitle');
                        echo '<span ' . $this->get_render_attribute_string('subtitle') . '>';
                        echo wp_kses_post($settings['price_subtitle']);
                        echo '</span>';
                    } ?>

                </div>

                <?php if (!empty($settings['price_info'])) {
                    $this->add_render_attribute('desc', 'class', 'chk-table-price-1__desc');
                    echo '<p ' . $this->get_render_attribute_string('desc') . '>';
                    echo wp_kses_post($settings['price_info']);
                    echo '</p>';
                } ?>

                <?php if (!empty($settings['price_amount'])) {
                    $price_wrapp = [
                        'chk-table-price-1__price',
                        'd-flex',
                        'z-2',
                        'pos-relative',
                        !empty($settings['price_prefix']) ? 'justify-between' : '',
                    ];
                    $price_wrap = implode(' ', $price_wrapp);
                ?>
                    <div class="<?php echo $price_wrap; ?>">
                        <?php if (!empty($settings['price_prefix'])) {
                            $this->add_render_attribute('price_prefix', 'class', 'chk-table-price-1__prefix');
                            echo '<span ' . $this->get_render_attribute_string('price_prefix') . '>';
                            echo wp_kses_post($settings['price_prefix']);
                            echo '</span>';
                        } ?>

                        <div class="chk-table-price-1__amount">

                            <?php if (!empty($settings['currency_symbol']) && $settings['currency_symbol_position'] == 'before') {
                                echo '<span class="chk-table-price-1__currency">';
                                echo $settings['currency_symbol'];
                                echo '</span>';
                            } ?>

                            <strong class="chk-table-price-1__number">
                                <?php echo wp_kses_post($settings['price_amount']); ?>
                            </strong>

                            <?php if (!empty($settings['currency_symbol']) && $settings['currency_symbol_position'] == 'after') {
                                echo '<span class="chk-table-price-1__currency">';
                                echo $settings['currency_symbol'];
                                echo '</span>';
                            } ?>

                        </div>
                    </div>
                <?php } ?>

                <?php if ($settings['button_sw'] == 'yes' && !empty($settings['button_text'])) {
                    $btn_style = [
                        'chk-button',
                        'chk-button__default',
                        $settings['button_width'],
                    ];
                    $cls_btn = implode(' ', $btn_style);
                    echo '<div class="mt-auto">';
                    echo '<div class="chk-table-price-1__button">';
                    Chakavak_Controls_Elementor::render_start_link($this, $settings['button_link'], $cls_btn);
                    echo '<span>' . wp_kses_post($settings['button_text']) . '</span>';
                    Chakavak_Controls_Elementor::render_end_link($this, $settings['button_link']);
                    echo '</div>';
                    echo '</div>';
                } ?>
            </div>
        </div>

<?php
    }

    protected function content_template() {}
}

Plugin::instance()->widgets_manager->register(new Chakavak_Pric_Table_1());
