<?php

namespace Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: price List
 */
class Chakavak_Pric_list extends Widget_Base
{
    const NAME = 'chk_price_list';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Price List', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-price-list';
    }

    public function get_keywords()
    {
        return ['pricing', 'price', 'money', __('price list', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-price-list'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content_list',
            [
                'label' => esc_html__('List', 'chakavak'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'price',
            [
                'label' => esc_html__('Price', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'default' => esc_html__('List Item Title Text', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => 'true',
                'dynamic' => ['active' => true],
            ]
        );

        $repeater->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => ['active' => true],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [],
                'dynamic' => ['active' => true],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'default' => ['url' => '#'],
                'dynamic' => ['active' => true],
            ]
        );

        $this->add_control(
            'price_list',
            [
                'label' => esc_html__('List Items', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('Title Item One', 'chakavak'),
                        'price' => '$20',
                        'link' => ['url' => '#'],
                    ],
                    [
                        'title' => esc_html__('Title Item Two', 'chakavak'),
                        'price' => '$9',
                        'link' => ['url' => '#'],
                    ],
                    [
                        'title' => esc_html__('Title Item Three', 'chakavak'),
                        'price' => '$32',
                        'link' => ['url' => '#'],
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'row_gap',
            [
                'label' => esc_html__('Rows Gap', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vertical_align',
            [
                'label' => esc_html__('Vertical Align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_vertical_position(),
                'description' => esc_html__('When you will take image then you understand its function', 'chakavak'),
                'default' => 'flex-start',
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__link' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-price-list__link',
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-price-list__link',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .chk-price-list__link',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'text_style',
            [
                'label' => esc_html__('Text Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_heading',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list .chk-price-list__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-price-list__title',
            ]
        );

        $this->add_control(
            'description_heading',
            [
                'label' => esc_html__('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => esc_html__('Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-price-list__desc',
            ]
        );

        $this->add_control(
            'separator_heading',
            [
                'label' => esc_html__('Separator', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'separator_style',
            [
                'label' => esc_html__('Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'solid' => esc_html__('Solid', 'chakavak'),
                    'dotted' => esc_html__('Dotted', 'chakavak'),
                    'dashed' => esc_html__('Dashed', 'chakavak'),
                    'double' => esc_html__('Double', 'chakavak'),
                    'none' => esc_html__('None', 'chakavak'),
                ],
                'default' => 'dashed',
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__separator' => 'border-bottom-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'separator_height',
            [
                'label' => esc_html__('Height', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 10,
                    ],
                ],
                'condition' => [
                    'separator_style!' => 'none',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__separator' => 'border-bottom-width: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'size' => 1,
                ],
            ]
        );

        $this->add_control(
            'separator_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__separator' => 'border-bottom-color: {{VALUE}};',
                ],
                'condition' => [
                    'separator_style!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'separator_spacing',
            [
                'label' => esc_html__('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 40,
                    ],
                ],
                'condition' => [
                    'separator_style!' => 'none',
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__separator' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => esc_html__('Image Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__image' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_spacing',
            [
                'label' => esc_html__('Spacing', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    'body.rtl {{WRAPPER}} .chk-price-list__image' => 'padding-left: calc({{SIZE}}{{UNIT}}/2);',
                    'body:not(.rtl) {{WRAPPER}} .chk-price-list__image' => 'padding-right: calc({{SIZE}}{{UNIT}}/2);',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_price',
            [
                'label' => esc_html__('Price', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'show_label' => false,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'label' => esc_html__('Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-price-list__price',
            ]
        );


        $this->add_control(
            'price_color',
            [
                'label' => esc_html__('Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-price-list__price' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <ul class="chk-price-list list-none">
                <?php foreach ($settings['price_list'] as $item) : ?>
                    <li class="chk-price-list__item pos-relative">
                        <?php
                        if (!empty($item['link'])) {
                            \Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'chk-price-list__link');
                        } else {
                            echo '<span class="chk-price-list__link">';
                        } ?>
                        <?php if (!empty($item['image']['id'])) {
                            echo '<div class="chk-price-list__image">';
                            $imageTagHtml = wp_get_attachment_image($item['image']['id'], 'full', "", ["alt" => $item['title']]);
                            echo $imageTagHtml;
                            echo '</div>';
                        } ?>

                        <div class="chk-price-list__text">
                            <div class="chk-price-list__header">
                                <?php if (!empty($item['title'])) : ?>
                                    <span class="chk-price-list__title"><?php echo esc_html($item['title']); ?></span>
                                <?php endif; ?>

                                <?php if ('none' != $settings['separator_style']) : ?>
                                    <span class="chk-price-list__separator"></span>
                                <?php endif; ?>

                                <?php if (!empty($item['price'])) : ?>
                                    <span class="chk-price-list__price"><?php echo esc_html($item['price']); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($item['desc'])) : ?>
                                <p class="chk-price-list__desc"><?php echo $this->parse_text_editor($item['desc']); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php
                        if (!empty($item['link'])) {
                            \Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                        } else {
                            echo '</span>';
                        } ?>

                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Pric_list());
