<?php

namespace Elementor;
defined('ABSPATH') or exit;

/**
 * Widget Name: Paragraph
 */
class Chakavak_Paragraph extends Widget_Base
{
    const NAME = 'chk_paragraph';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Paragraph', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-text-align-right';
    }

    public function get_keywords()
    {
        return ['paragraph', esc_html__('description', 'chakavak'), esc_html__('Paragraph', 'chakavak'), esc_html__('text', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'paragraph',
            [
                'label' => esc_html__('Content', 'chakavak'),
                'label_block' => true,
                'type' => Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__('Enter Description', 'chakavak'),
                'description' => esc_html__('You can use HTML.', 'chakavak'),
                'default' => esc_html__('Lorem ipsum dolor sit amet cotetur adipisicing elit, sed do mod tempor incididunt ut labore etdolore emu some the and one baldbe dear.', 'chakavak'),
            ]
        );
        $text_columns = range(1, 4);
        $text_columns = array_combine($text_columns, $text_columns);
        $text_columns[''] = esc_html__('Default', 'chakavak');

        $this->add_responsive_control(
            'text_columns',
            [
                'label' => esc_html__('Columns', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'separator' => 'before',
                'options' => $text_columns,
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph' => 'columns: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label' => esc_html__('Columns Gap', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                    '%' => [
                        'max' => 10,
                        'step' => 0.1,
                    ],
                    'em' => [
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'text_columns!' => ['', '1']
                ]
            ]
        );
        $this->add_responsive_control(
            'paragraph_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment(),
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'paragraph_height',
            [
                'label' => esc_html__('Max height', 'chakavak'),
                'type' => Controls_Manager::NUMBER,
                'min' => 50,
                'max' => 500,
                'step' => 1,
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph' => 'max-height: {{VALUE}}px;',
                ],
            ]
        );

        $this->end_controls_section();

        //paragraph_style
        $this->start_controls_section(
            'paragraph_style',
            [
                'label' => esc_html__('Paragraph', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'paragraph!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'paragraph_typography',
                'selector' => '{{WRAPPER}} .chk-paragraph',
            ]
        );

        $this->add_control(
            'paragraph_color',
            [
                'label' => esc_html__('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'paragraph_shadow',
                'selector' => '{{WRAPPER}} .chk-paragraph',
            ]
        );

        $this->add_control(
            'heading_head',
            [
                'label' => __('Heading tags', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__('Heading Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph :is(h1,h2,h3,h4,h5,h6)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h1_typography',
                'label' => __('H1 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-paragraph h1',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h2_typography',
                'label' => __('H2 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-paragraph h2',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h3_typography',
                'label' => __('H3 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-paragraph h3',
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h4_typography',
                'label' => __('H4 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-paragraph h4',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h5_typography',
                'label' => __('H5 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-paragraph h5',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'h6_typography',
                'label' => __('H6 Typography', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-paragraph h6',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'scrollbar_style',
            [
                'label' => esc_html__('Scrollbar', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'paragraph_height!' => '',
                ],
            ]
        );

        $this->add_control(
            'scrollbar_description',
            [
                'raw' => __('Only for Google Chrome browser & Webkit prefixes in Desktop', 'chakavak'),
                'type' => Controls_Manager::RAW_HTML,
                'content_classes' => 'elementor-descriptor',
            ]
        );

        $this->add_control(
            'scrollbar_track_bg_color',
            [
                'label' => esc_html__('Background scroll', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph::-webkit-scrollbar-track' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'scrollbar_thumb_color',
            [
                'label' => esc_html__('Scrollbar Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-paragraph::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('paragraph', 'class', 'chk-paragraph chk-classic-editor');
        //$this->add_inline_editing_attributes( 'paragraph', 'basic' );
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('paragraph'); ?>>
                <?php
                if (!empty($settings['paragraph'])) :
                    echo $settings['paragraph'];
                endif; ?>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Paragraph());
