<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Icon Box Grid 2
 */
class Chakavak_Icon_Box_Grid_2 extends Widget_Base
{
    const NAME = 'chk_icon_box_carousel_2';
    const CATEGORY = 'chakavak_widgets';

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_name()
    {
        return self::NAME;
    }

    public function get_title()
    {
        return esc_html__('Icon Box Grid 2', 'chakavak');
    }

    public function get_keywords()
    {
        return ['icon', 'box', 'carousel', 'info box', esc_html__('icon box', 'chakavak')];
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-gallery-grid';
    }

    public function get_style_depends()
    {
        return [
            'chk-icon-box-2'
        ];
    }

    public function get_script_depends()
    {
        return [];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
            ]
        );

        $this->add_control(
            'box_style',
            [
                'label' => __('Box Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 's1',
                'options' => [
                    's1' => __('Style 1: Icon right', 'chakavak'),
                    's2' => __('Style 2: Icon left', 'chakavak'),
                    's3' => __('Style 3: Icon top', 'chakavak'),
                ]
            ]
        );

        $this->add_control(
            'items_heading',
            [
                'label' => esc_html__('Items', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('UI/UX Design', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Crafting Digital Experiences', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'none' => __('None', 'chakavak'),
                    'font' => __('Font Icon', 'chakavak'),
                    'image' => __('Image Icon', 'chakavak'),
                ]
            ]
        );

        $repeater->add_control(
            'icon_font',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'ti-business',
                    'library' => 'theme-icons',
                ],
                'condition' => [
                    'icon_type' => 'font',
                ]
            ]
        );

        $repeater->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
            ]
        );

        $repeater->add_control(
            'desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Build the product you need on time with an experienced team that uses a clear and effective design process.', 'chakavak'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->add_control(
            'icon_boxes',
            [
                'label' => __('Content Items', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'show_label' => false,
                'default' => [
                    [
                        'title' => esc_html__('Web Development', 'chakavak'),
                        'desc' => esc_html__('We carry more than just good coding skills. Our experience makes us stand out from other web development.', 'chakavak'),
                        'icon_font' => [
                            'value' => 'ti-business',
                            'library' => 'theme-icons',
                        ],
                    ],
                    [
                        'title' => esc_html__('UI/UX Design', 'chakavak'),
                        'desc' => esc_html__('Build the product you need on time with an experienced team that uses a clear and effective design process.', 'chakavak'),
                        'icon_font' => [
                            'value' => 'ti-dashboard',
                            'library' => 'theme-icons',
                        ],
                    ],
                    [
                        'title' => esc_html__('IT Counsultancy', 'chakavak'),
                        'desc' => esc_html__('Trust our top minds to eliminate workflow pain points, implement new tech, and consolidate app portfolios.', 'chakavak'),
                        'icon_font' => [
                            'value' => 'ti-goal',
                            'library' => 'theme-icons',
                        ],
                    ]
                ],
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{title}}}',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h2',
            ]
        );

        $this->add_control(
            'subtitle_tag',
            [
                'label' => esc_html__('Subtitle Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
            ]
        );

        $this->add_control(
            'desc_tag',
            [
                'label' => esc_html__('Select Tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'p',
            ]
        );

        $this->end_controls_section();

        Chakavak_Controls_Elementor::add_control_grid($this);

        //Item Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-icon-box-2',
                'separator' => 'before',
                'exclude' => ['color'],
            ]
        );

        $this->start_controls_tabs('item_tabs');
        $this->start_controls_tab(
            'item_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-2',
            ]
        );

        $this->add_control(
            'item_border_normal',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_normal',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 0,
                                'blur' => 5,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.08)'
                            ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .chk-icon-box-2',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'item_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-2:before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-2:hover',
                'fields_options' => [
                    'box_shadow_type' =>
                        [
                            'default' => 'yes'
                        ],
                    'box_shadow' => [
                        'default' =>
                            [
                                'horizontal' => 0,
                                'vertical' => 3,
                                'blur' => 15,
                                'spread' => 0,
                                'color' => 'rgba(0,0,0,0.12)'
                            ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_border_hover',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        //icon style
        $this->start_controls_section(
            'icon_style',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__icon' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_position',
            [
                'label' => esc_html__('Icon position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_vertical_position(),
                'default' => 'flex-start',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .chk-icon-box-2__icon',
            ]
        );

        $this->start_controls_tabs('icon_tabs');

        $this->start_controls_tab(
            'tab_icon_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-2__icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_normal',
                'selector' => '{{WRAPPER}} .chk-icon-box-2__icon img',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bgcolor_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-2__icon',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow',
                'selector' => '{{WRAPPER}} .chk-icon-box-2__icon',
            ]
        );
        $this->end_controls_tab();
        //hover
        $this->start_controls_tab(
            'tab_icon_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__icon img',
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'icon_bgcolor_hover',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-icon-box-2__icon:before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'icon_box_shadow_hover',
                'selector' => '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__icon',
            ]
        );

        $this->add_control(
            'icon_border_hover',
            [
                'label' => esc_html__('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'style_content_section',
            [
                'label' => __('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-2__title',
            ]
        );

        $this->add_responsive_control(
            'title_space',
            [
                'label' => __('Margin bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__title,
					 {{WRAPPER}} .chk-icon-box-2__title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__title,
					 {{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        //subtitle
        $this->add_control(
            'heading_subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-2__subtitle',
            ]
        );

        $this->add_responsive_control(
            'subtitle_space',
            [
                'label' => __('Margin bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_hover_color',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-icon-box-2__desc',
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2__desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'desc_hover_color',
            [
                'label' => __('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-icon-box-2:hover .chk-icon-box-2__desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $classes = [];
        $classes[] = 'chk-icon-box-group-2 chk-layout-grid';
        $this->add_render_attribute('wrapper', 'class', $classes);
        $this->add_render_attribute('chk-icon-box-2', 'class', 'chk-icon-box-2 pos-relative transition-all z-1 chk-bg-before h-full');
        $this->add_render_attribute('chk-icon-box-2', 'class', $settings['box_style']);
        Chakavak_Controls_Elementor::get_grid_settings($this);
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
                <div <?php echo $this->get_render_attribute_string('grid') ?>>
                    <?php
                    foreach ($settings['icon_boxes'] as $item) : ?>
                        <div class="col-xs">
                            <div <?php echo $this->get_render_attribute_string('chk-icon-box-2'); ?>>
                                <?php if ($item['icon_type'] != 'none') { ?>
                                    <div class="chk-icon-box-2__icon pos-relative if-center transition-all chk-bg-before z-1 overflow-hidden">
                                        <?php if ($item['icon_type'] == 'font') {
                                            Icons_Manager::render_icon($item['icon_font'], [
                                                'aria-hidden' => 'true',
                                                'class' => 'pos-relative'
                                            ]);
                                        } ?>
                                        <?php if ($item['icon_type'] == 'image') { ?>
                                            <img src="<?php echo esc_attr($item['icon_image']['url']); ?>" alt="<?php
                                            echo esc_attr(esc_html($item['title'])); ?>" class="pos-relative z-1 lh-0">
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                                <div class="chk-icon-box-2__content pos-relative z-1">

                                    <?php if (!empty($item['title'])) {
                                        $tag_title = $settings['title_tag'];
                                        $cls_title = "chk-icon-box-2__title pos-relative z-1 lh-1 transition-all";
                                        echo "<{$tag_title} class=\"{$cls_title}\">";
                                        Chakavak_Controls_Elementor::render_start_link($this, $item['link'], 'd-block transition-all');
                                        echo esc_html($item['title']);
                                        Chakavak_Controls_Elementor::render_end_link($this, $item['link']);
                                        echo "</{$tag_title}>";
                                    } ?>

                                    <?php if (!empty($item['subtitle'])) {
                                        $tag_subtitle = $settings['subtitle_tag'];
                                        $cls_subtitle = "chk-icon-box-2__subtitle transition-all";
                                        echo "<{$tag_subtitle} class=\"{$cls_subtitle}\">";
                                        echo esc_html($item['subtitle']);
                                        echo "</{$tag_subtitle}>";
                                    } ?>

                                    <?php if (!empty($item['desc'])) {
                                        $tag_desc = $settings['desc_tag'];
                                        $cls_desc = "chk-icon-box-2__desc transition-all";
                                        echo "<{$tag_desc} class=\"{$cls_desc}\">";
                                        echo wp_kses_post($item['desc']);
                                        echo "</{$tag_desc}>";
                                    } ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Icon_Box_Grid_2());
