<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Contact Icon
 */
class Chakavak_Contact_Icon extends Widget_Base
{
    const NAME = 'chk_contact_icon';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Contact Icon', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-call-to-action';
    }

    public function get_keywords()
    {
        return ['icon', 'conact', 'icon box', 'contact box', esc_html__('contact box', 'chakavak')];
    }

    public function get_style_depends()
    {
        return ['chk-contact-icon'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'contact_settings',
            [
                'label' => esc_html__('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon_align',
            [
                'label' => __('Icon Alignment', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 's1',
                'options' => [
                    's1' => __('Icon right', 'chakavak'),
                    's2' => __('Icon left', 'chakavak'),
                    's3' => __('Icon center', 'chakavak'),
                    's4' => __('Icon none', 'chakavak'),
                ],
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'font',
                'options' => [
                    'font' => __('Font Icon', 'chakavak'),
                    'image' => __('Image', 'chakavak'),
                ],
                'separator' => 'before',
                'condition' => [
                    'icon_align!' => 's4',
                ]
            ]
        );

        $this->add_control(
            'icon_font',
            [
                'label' => __('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon_type' => 'font',
                    'icon_align!' => 's4',
                ]
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => CHAKAVAK_ELEMENTOR_ASSETS . 'images/icon.png',
                ],
                'condition' => [
                    'icon_type' => 'image',
                    'icon_align!' => 's4',
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('02188665544', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => '3',
                'default' => __('Get a free consultation', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => 'https://your-link.com',
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_align',
            [
                'label' => esc_html__('Align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => true,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} ' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'icon_align' => 's3'
                ]
            ]
        );

        $this->end_controls_section();

        //Style icon
        $this->start_controls_section(
            'item_style',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .chk-contact-icon',
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-contact-icon',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .chk-contact-icon',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => __('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-end' => [
                        'title' => esc_html__('Left', 'chakavak'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'chakavak'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-start' => [
                        'title' => esc_html__('Right', 'chakavak'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__content' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_space',
            [
                'label' => __('Title spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__content' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_style',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h3',
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'condition' => [
                    'title!' => '',
                ],
                'selector' => '{{WRAPPER}} .chk-contact-icon__title',
            ]
        );

        $this->add_responsive_control(
            'title_order',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    '-1' => [
                        'title' => esc_html__('Top', 'chakavak'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    '99' => [
                        'title' => esc_html__('Bottom', 'chakavak'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'default' => '-1',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__title' => 'order: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_color_style',
            [
                'label' => esc_html__('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_color_style_hover',
            [
                'label' => esc_html__('Text color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon:hover .chk-contact-icon__title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'subtitle_style_heading',
            [
                'label' => __('Subtitle', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->add_control(
            'subtitle_tag',
            [
                'label' => esc_html__('Subtitle tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h5',
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'selector' => '{{WRAPPER}} .chk-contact-icon__subtitle',
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color_style',
            [
                'label' => esc_html__('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__subtitle' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'subtitle!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        //icon-image
        $this->start_controls_section(
            'image_style',
            [
                'label' => __('Image / Icon', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_align!' => 's4',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_position',
            [
                'label' => esc_html__('Icon position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_vertical_position(),
                'default' => 'flex-start',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon' => 'align-items: {{VALUE}};',
                ],
                'condition' => [
                    'icon_align!' => 's3',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Image width', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__image i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-contact-icon__image img' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .chk-contact-icon__image svg' => 'width: {{SIZE}}{{UNIT}};height:auto;',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon__image i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-contact-icon__image svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type!' => 'image',
                ]
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Icon color hover', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-contact-icon:hover .chk-contact-icon__image i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .chk-contact-icon:hover .chk-contact-icon__image svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type!' => 'image',
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $style = $settings['icon_align'];
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="<?php echo $this->get_name(); ?>-element chk-element">
                <div class="chk-contact-icon d-inline-flex pos-relative transition-all chk-contact-icon__<?php echo esc_attr($style); ?>">
                    <?php Chakavak_Controls_Elementor::render_link_overlay($this, $settings['link'], 'chk-link-overlay chk-contact-icon__link'); ?>
                    <?php if ($settings['icon_align'] != 's4') : ?>
                        <div class="chk-contact-icon__image pos-relative if-center transition-all z-1 overflow-hidden">
                            <?php if ($settings['icon_type'] == 'font') {
                                Icons_Manager::render_icon($settings['icon_font'], ['aria-hidden' => 'true']);
                            } ?>
                            <?php if ($settings['icon_type'] == 'image') { ?>
                                <img src="<?php echo esc_attr($settings['icon_image']['url']); ?>" alt="<?php echo
                                esc_attr(esc_html($settings['title'])); ?>">
                            <?php } ?>
                        </div>
                    <?php endif; ?>
                    <div class="chk-contact-icon__content">
                        <?php if (!empty($settings['title'])) {
                            $tag_title = $settings['title_tag'];
                            $cls_title = "chk-contact-icon__title d-block transition-all";
                            echo "<{$tag_title} class=\"{$cls_title}\">";
                            echo esc_html($settings['title']);
                            echo "</{$tag_title}>";
                        } ?>

                        <?php if (!empty($settings['subtitle'])) {
                            $tag_subtitle = $settings['subtitle_tag'];
                            $cls_subtitle = "chk-contact-icon__subtitle";
                            echo "<{$tag_subtitle} class=\"{$cls_subtitle}\">";
                            echo esc_html($settings['subtitle']);
                            echo "</{$tag_subtitle}>";
                        } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Contact_Icon());
