<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Button 2
 */
class chakavak_Button_2 extends Widget_Base
{
    const NAME = 'chk_button_2';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Button 2', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-button';
    }

    public function get_keywords()
    {
        return ['button', 'icon', __('button', 'chakavak')];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('General', 'chakavak'),
            ]
        );

        $this->add_control(
            'btn_full_width',
            [
                'label' => esc_html__('Full Width', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => esc_html__('Yes', 'chakavak'),
                'label_off' => esc_html__('No', 'chakavak'),
                'return_value' => 'yes',
            ]
        );

        $this->add_responsive_control(
            'btn_content_justify',
            [
                'label' => __('Content Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'justify-between' => [
                        'title' => esc_html__('Space between', 'chakavak'),
                        'icon' => 'eicon-align-stretch-h',
                    ],
                    'justify-center' => [
                        'title' => esc_html__('Center', 'chakavak'),
                        'icon' => 'eicon-flex eicon-align-center-h',
                    ],
                ],
                'default' => 'justify-center',
                'condition' => [
                    'btn_full_width' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_align',
            [
                'label' => __('Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment_2(),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'btn_full_width!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('021-8866-5544', 'chakavak'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => esc_html__('Link', 'chakavak'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => '',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'selector' => '',
            ]
        );

        $this->add_control(
            'icon_font',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'ti-phone',
                    'library' => 'theme-icons',
                ],
            ]
        );

        $this->add_control(
            'icon_align',
            [
                'label' => esc_html__('Icon Position', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'before',
                'options' => [
                    'before' => esc_html__('Before', 'chakavak'),
                    'after' => esc_html__('After', 'chakavak'),
                ],
                'condition' => [
                    'icon_font!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding Box', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('Space Between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .chk-button-2__label',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .chk-button-2__link',
                'exclude' => ['color'],
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('button_tabs');

        $this->start_controls_tab(
            'button_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_bg_normal',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-button-2__link',
            ]
        );

        $this->add_control(
            'button_color_normal',
            [
                'label' => __('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_normal',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-button-2__link',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'button_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button_bg_hover',
                'label' => esc_html__('Background Color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-button-2__link:before',
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => __('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link:is(:hover,:focus)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_color_hover',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__link:is(:hover,:focus)' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow_hover',
                'selector' => '.chk-button-2__link:is(:hover,:focus)',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        //icon
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __('Icon Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_font[value]!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('Icon Size', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('Padding', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__icon' => '--icon-padding: {{SIZE}}{{UNIT}}',
                ],
                'default' => [
                    'unit' => 'em',
                ],
                'tablet_default' => [
                    'unit' => 'em',
                ],
                'mobile_default' => [
                    'unit' => 'em',
                ],
                'range' => [
                    'px' => [
                        'max' => 50,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
            ]
        );

        $this->add_control(
            'icon_radius',
            [
                'label' => __('Border Radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} .chk-button-2__icon',
                'exclude' => ['color'],
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('icon_tabs');
        $this->start_controls_tab(
            'icon_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_bg_normal',
            [
                'label' => __('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color_normal',
            [
                'label' => __('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color_normal',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'icon_bg_hover',
            [
                'label' => __('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2>a:is(:hover,:focus) .chk-button-2__icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Text Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2>a:is(:hover,:focus) .chk-button-2__icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color_hover',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-button-2>a:is(:hover,:focus) .chk-button-2__icon' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $cls = [
            'chk-button-2__link',
            'd-inline-flex',
            'items-center',
            'pos-relative',
            'chk-bg-before',
            'overflow-hidden',
            'z-1',
            'transition-all',
            'chk-button-2__align-' . $settings['icon_align'],
        ];
        if ($settings['btn_full_width'] == 'yes') {
            $cls[] = 'chk-button-2__full-' . $settings['btn_full_width'];
            $cls[] = 'w-full';
            $cls[] = $settings['btn_content_justify'];
        }

        $cls_btn = implode(' ', $cls);
        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div class="chk-button-2">
                <?php Chakavak_Controls_Elementor::render_start_link($this, $settings['link'], $cls_btn); ?>
                <?php if (!empty($settings['icon_font']['value'])) {
                    echo '<span class="chk-button-2__icon pos-relative z-1 if-center transition-all ">';
                    Icons_Manager::render_icon($settings['icon_font'], ['aria-hidden' => 'true']);
                    echo '</span>';
                    if ('' !== $settings['title']) {
                        echo '<span class="chk-button-2__label pos-relative z-1">' . esc_html($settings['title']) . '</span>';
                    }
                } ?>
                <?php Chakavak_Controls_Elementor::render_end_link($this, $settings['link']); ?>
            </div>
        </div>
        <?php
    }

    protected function content_template()
    {
    }
}

Plugin::instance()->widgets_manager->register(new chakavak_Button_2());
