<?php

namespace Elementor;
defined('ABSPATH') or exit;

/**
 * Widget Name: banner-instagram
 */
class Chakavak_Banner_Instagram extends Widget_Base
{
    const NAME = 'chk_banner_instagram';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Instagram Banner', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-banner';
    }

    public function get_style_depends()
    {
        return ['chk-elementor-widgets'];
    }

    public function get_keywords()
    {
        return ['instagram', 'banner', esc_html__('instagram banner', 'chakavak')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'instagram_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Instagram page Chakavak', 'chakavak'),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Notification of discounts, free training and practical tips and weekly live shows', 'chakavak'),
            ]
        );

        $this->add_control(
            'heading_button',
            [
                'label' => esc_html__('Button', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Label', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('View Posts', 'chakavak'),
                'placeholder' => __('Enter label button', 'chakavak'),
            ]
        );

        $this->add_control(
            'id_page',
            [
                'label' => __('ID Page', 'chakavak'),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__('Just enter the name of the page without @.', 'chakavak'),
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('mehditayebi.ir', 'chakavak'),
                'placeholder' => __('Enter ID instagram page', 'chakavak'),
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => esc_html__('Icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'skin' => 'inline',
                'label_block' => false,
                'default' => [
                    'value' => 'ti-logo-instagram',
                    'library' => 'theme-icons',
                ],
            ]
        );

        $this->add_control(
            'icon_align',
            [
                'label' => esc_html__('Icon Position', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 'before',
                'options' => [
                    'before' => esc_html__('Before', 'chakavak'),
                    'after' => esc_html__('After', 'chakavak'),
                ],
                'condition' => [
                    'selected_icon[value]!' => ''
                ],
            ]
        );

        $this->add_control(
            'target_link',
            [
                'label' => esc_html__('Target link', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '_blank' => esc_html__('Blank', 'chakavak'),
                    '_self' => esc_html__('Self', 'chakavak'),
                ],
                'default' => '_blank',
            ]
        );

        $this->end_controls_section();

        //Style
        $this->start_controls_section(
            'item_style',
            [
                'label' => __('Item', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content_position',
            [
                'label' => esc_html__('Content Position', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'chk-content-horizontal',
                'options' => [
                    'chk-content-horizontal' => [
                        'title' => esc_html__('Horizontal', 'chakavak'),
                        'icon' => 'eicon-arrow-right',
                    ],
                    'chk-content-vertical' => [
                        'title' => esc_html__('Vertical', 'chakavak'),
                        'icon' => 'eicon-arrow-down',
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

//Title
        $this->add_control(
            'heading_title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-banner-social__title',
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'title_shadow',
                'label' => esc_html__('Title shadow', 'chakavak'),
                'selector' => '{{WRAPPER}} .chk-banner-social__title',
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__('Spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__title' => 'margin-bottom:{{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'title!' => '',
                ],
            ]
        );

        // Desc
        $this->add_control(
            'heading_desc',
            [
                'label' => __('Description', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'condition' => [
                    'desc!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'selector' => '{{WRAPPER}} .chk-banner-social__desc',
                'condition' => [
                    'desc!' => '',
                ],
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__('Description color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__desc' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'desc!' => '',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'desc_shadow',
                'selector' => '{{WRAPPER}} .chk-banner-social__desc',
                'condition' => [
                    'desc!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'desc_spacing',
            [
                'label' => esc_html__('Spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'desc!' => '',
                    'content_position' => 'content-vertical'
                ],
            ]
        );

        $this->end_controls_section();

        //Style button
        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button Style', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Button Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .chk-banner-social__link',
            ]
        );

        //tabs
        $this->start_controls_tabs('button_tabs');

        $this->start_controls_tab(
            'button_tab_normal',
            [
                'label' => __('Normal', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_text_color_normal',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link' => 'color:{{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'button_border_color_normal',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link' => 'border-color:{{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'button_bgcolor_normal',
            [
                'label' => __('Background color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link' => 'background-color:{{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_tab_hover',
            [
                'label' => __('Hover', 'chakavak'),
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link:is(:hover,:focus)' => 'color:{{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'button_border_color_hover',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link:is(:hover,:focus)' => 'border-color:{{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'button_bgcolor_hover',
            [
                'label' => __('Background Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__link:is(:hover,:focus)' => 'background-color:{{VALUE}}'
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'heading_id_insta',
            [
                'label' => __('ID Instagram', 'chakavak'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'id_insta_typography',
                'selector' => '{{WRAPPER}} .chk-banner-social__id',
            ]
        );

        $this->add_control(
            'id_insta_color',
            [
                'label' => __('Label color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-banner-social__id' => 'color:{{VALUE}}'
                ]
            ]
        );

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $wrap = [
            'chk-banner-social chk-banner-social__instagram',
            $settings['content_position'],
        ];
        $this->add_render_attribute('wrapper', 'class', $wrap);

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?> >
                <div class="chk-banner-social__content">
                    <?php if (!empty($settings['title'])) {
                        $this->add_render_attribute('title', 'class', 'chk-banner-social__title');
                        echo '<' . $settings['title_tag'] . ' ' . $this->get_render_attribute_string('title') . '>';
                        echo esc_html($settings['title']);
                        echo '</' . $settings['title_tag'] . '>';
                    } ?>

                    <?php if (!empty($settings['desc'])) {
                        $this->add_render_attribute('desc', 'class', 'chk-banner-social__desc');
                        echo '<p ' . $this->get_render_attribute_string('desc') . '>' . wp_kses_post($settings['desc']) . '</p>';
                    } ?>

                </div>
                <?php if (!empty($settings['id_page'])) :
                    $this->add_render_attribute('btn_link', 'class', 'chk-button chk-banner-social__link chk-button-instagram');
                    $this->add_render_attribute('btn_link', 'class', 'chk-button__icon-' . $settings['icon_align']);
                    ?>
                    <div class="chk-banner-social__buttons">
                        <a href="https://instagram.com/<?php echo esc_html($settings['id_page']); ?>" title="<?php echo
                        esc_html__('Instagram page', 'chakavaK'); ?>" <?php echo $this->get_render_attribute_string('btn_link'); ?> target="<?php echo $settings['target_link']; ?>">
							<span>
								<?php Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']); ?>
                                <?php echo !empty($settings['button_label']) ? esc_html($settings['button_label']) :
                                    esc_html__('View Posts', 'chakavak'); ?>
							</span>
                        </a>
                        <strong class="ltr chk-banner-social__id chk-instagram-id">
                            @<?php echo esc_html($settings['id_page']); ?>
                        </strong>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Chakavak_Banner_Instagram());
