<?php

namespace Elementor;

use Chakavak_Controls_Elementor;

defined('ABSPATH') or exit;

/**
 * Widget Name: Accordions 1
 */
class chk_Accordions_1 extends Widget_Base
{

    const NAME = 'chk_accordions_1';
    const CATEGORY = 'chakavak_widgets';

    public function get_name()
    {
        return self::NAME;
    }

    public function get_categories()
    {
        return array(self::CATEGORY);
    }

    public function get_title()
    {
        return __('Accordions 1', 'chakavak');
    }

    public function get_icon()
    {
        return 'chk-el-icon eicon-accordion';
    }

    public function get_style_depends()
    {
        return ['chk-accordions-1'];
    }

    public function get_script_depends()
    {
        return ['chk-widgets'];
    }

    public function get_keywords()
    {
        return ['accordion', 'faq', 'question', esc_html__('Accordion', 'chakavak')];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Accordions', 'chakavak'),
            ]
        );

        $this->add_control(
            'acc_style',
            [
                'label' => __('Style', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'default' => 's1',
                'options' => [
                    's1' => __('Style 1', 'chakavak'),
                    's2' => __('Style 2', 'chakavak'),
                ]
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'acc_title',
            [
                'label' => __('Title', 'chakavak'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 3,
                'default' => __('Accordion Title', 'chakavak'),
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'acc_type',
            [
                'label' => esc_html__('Content Type', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options' => [
                    'content' => esc_html__('Content', 'chakavak'),
                    'image' => esc_html__('Image', 'chakavak'),
                    'section' => esc_html__('Saved Section', 'chakavak'),
                ],
                'default' => 'content',
            ]
        );

        $repeater->add_control(
            'acc_content',
            [
                'label' => esc_html__('Content', 'chakavak'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => esc_html__('Click to edit sample text of accordion content lacus quam faucibus in aliquam vitae placerat pretium eros. Aliquam et pulvinar odio vitae imperdiet purus amet blandit eros.', 'chakavak'),
                'dynamic' => ['active' => true],
                'condition' => [
                    'acc_type' => 'content',
                ],
            ]
        );

        $repeater->add_control(
            'acc_image',
            [
                'label' => esc_html__('Image', 'chakavak'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'acc_type',
                            'operator' => '==',
                            'value' => 'image',
                        ],
                    ],
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image',
                'label' => esc_html__('Image size', 'chakavak'),
                'default' => 'large',
                'exclude' => ['custom', '1536x1536', '2048x2048'],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'acc_type',
                            'operator' => '==',
                            'value' => 'image',
                        ],
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'acc_saved_section',
            [
                'label' => esc_html__('Choose section', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => Chakavak_Controls_Elementor::get_page_template_options('section'),
                'default' => '-1',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'acc_type',
                            'operator' => '==',
                            'value' => 'section',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'acc_items',
            [
                'label' => __('Accordion items', 'chakavak'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'acc_title' => __(' These cases are perfectly simple.', 'chakavak'),
                        'acc_content' => __('We make websites are the number one ranked design, build and marketing team. Creative and beautiful websites that will make you more successful. sunt in culpa qui officia deserunt mollit anim id est laborum.', 'chakavak'),
                    ],
                    [
                        'acc_title' => __('Etiam mollis libero vitae pulvinar bibendum.', 'chakavak'),
                        'acc_content' => __('We make websites are the number one ranked design, build and marketing team. Creative and beautiful websites that will make you more successful. sunt in culpa qui officia deserunt mollit anim id est laborum.', 'chakavak'),
                    ],
                    [
                        'acc_title' => __('Sed do eiusmod tempor incididunt ut labore.', 'chakavak'),
                        'acc_content' => __('We make websites are the number one ranked design, build and marketing team. Creative and beautiful websites that will make you more successful. sunt in culpa qui officia deserunt mollit anim id est laborum.', 'chakavak'),
                    ],
                ],
                'title_field' => '{{{ acc_title }}}',
            ]
        );

        $this->add_control(
            'default_active',
            [
                'label' => esc_html__('Default Active', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'item_active',
            [
                'label' => esc_html__('Item Active', 'chakavak'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 1,
                'default' => 1,
                'condition' => [
                    'default_active' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'item_title_tag',
            [
                'label' => esc_html__('Item title tag', 'chakavak'),
                'type' => Controls_Manager::SELECT,
                'options' => chakavak_heading(),
                'default' => 'h4',
            ]
        );

        $this->add_control(
            'heading_toggle_icon',
            [
                'label' => __('Normal', 'chakavak'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'toggle_default',
            [
                'label' => __('Default icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'separator' => 'before',
                'fa4compatibility' => 'select_default_icon',
                'default' => [
                    'value' => 'ti-arrow-down',
                    'library' => 'theme-icons',
                ],
                'skin' => 'inline',
                'label_block' => false,
            ]
        );

        $this->add_control(
            'toggle_active',
            [
                'label' => __('Active icon', 'chakavak'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'select_active_icon',
                'default' => [
                    'value' => 'ti-arrow-up',
                    'library' => 'theme-icons',
                ],
                'skin' => 'inline',
                'label_block' => false,
                'condition' => [
                    'toggle_default[value]!' => '',
                ]
            ]
        );

        $this->add_control(
            'toggle_align',
            [
                'label' => esc_html__('Icon Alignment', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__('Start', 'chakavak'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'end' => [
                        'title' => esc_html__('End', 'chakavak'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'start',
                'toggle' => false,
            ]
        );

        $this->add_control(
            'faq_schema',
            [
                'label' => esc_html__('FAQ Schema', 'chakavak'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'faq_schema_description',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => __('Only when Content-type is equal to "content".', 'chakavak'),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info'
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'acc_item_style',
            [
                'label' => __('Accordion', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'acc_space',
            [
                'label' => __('Spacing between', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-accordions-1 ' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'acc_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'exclude' => ['color'],
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                            'isLinked' => true,
                        ]
                    ],
                ],
                'selector' => '{{WRAPPER}} .chk-acc-1-item',
            ]
        );

        $this->add_responsive_control(
            'acc_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('acc_style_tabs');

        //normal
        $this->start_controls_tab(
            'acc_tab_normal',
            [
                'label' => __('Default', 'chakavak'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_normal',
                'label' => esc_html__('Background color', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-acc-1-item',

            ]
        );

        $this->add_control(
            'acc_border_color_normal',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => 'var(--chk-c-gray-200)',
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'item_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'acc_box_shadow_normal',
                'selector' => '{{WRAPPER}} .chk-acc-1-item',
            ]
        );

        $this->end_controls_tab();

        //Active

        $this->start_controls_tab(
            'acc_tab_active',
            [
                'label' => __('Active', 'chakavak'),
            ]
        );

        $this->add_control(
            'acc_border_color_active',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item.current' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'item_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'item_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'acc_box_shadow_active',
                'selector' => '{{WRAPPER}} .chk-acc-1-item.current',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /* Title Style */
        $this->start_controls_section(
            'acc_title_style',
            [
                'label' => __('Title', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .chk-acc-1-item__title',
            ]
        );

        $this->add_responsive_control(
            'acc_title_radius',
            [
                'label' => __('Border radius', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item.s1 .chk-acc-1-item__head' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'acc_style' => 's1',
                ],
            ]
        );

        $this->add_responsive_control(
            'acc_title_padding',
            [
                'label' => __('Padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item .chk-acc-1-item__head' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'acc_title_margin_bottom',
            [
                'label' => esc_html__('Spacing bottom', 'chakavak'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item__head' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'label' => esc_html__('Border', 'chakavak'),
                'name' => 'acc_title_border',
                'exclude' => ['color'],
                'condition' => [
                    'acc_style' => 's1',
                ],
                'selector' => '{{WRAPPER}} .chk-acc-1-item.s1 .chk-acc-1-item__head',
            ]
        );

        $this->start_controls_tabs('acc_title_tabs');

        //normal
        $this->start_controls_tab(
            'acc_title_normal',
            [
                'label' => __('Default', 'chakavak'),
            ]
        );

        $this->add_control(
            'acc_title_color_normal',
            [
                'label' => __('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item:not(.current) .chk-acc-1-item__head' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'acc_title_bgcolor_normal',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-acc-1-item.s1 .chk-acc-1-item__head',
                'separator' => 'before',
                'condition' => [
                    'acc_style' => 's1',
                ],
            ]
        );

        $this->add_control(
            'acc_title_border_color_normal',
            [
                'label' => __('Border Color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item.s1 .chk-acc-1-item__head' => 'border-color:{{VALUE}}',
                ],
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'acc_title_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'acc_title_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'acc_title_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'acc_title_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'acc_title_active',
            [
                'label' => __('Active', 'chakavak'),
            ]
        );

        $this->add_control(
            'acc_title_color_active',
            [
                'label' => __('Title color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item.s1.current .chk-acc-1-item__head' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'acc_title_border_color_active',
            [
                'label' => __('Border color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item.s1.current .chk-acc-1-item__head' => 'border-color: {{VALUE}};',
                ],
                'conditions' => [
                    'relation' => 'or', // or
                    'terms' => [
                        [
                            'name' => 'acc_title_border_width[top]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'acc_title_border_width[right]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'acc_title_border_width[left]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                        [
                            'name' => 'acc_title_border_width[bottom]',
                            'operator' => '!=',
                            'value' => ['0'],
                        ],
                    ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'acc_title_bgcolor_active',
                'label' => esc_html__('Background', 'chakavak'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .chk-acc-1-item.s1 .chk-acc-1-item__head:before',
                'separator' => 'before',
                'condition' => [
                    'acc_style' => 's1',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        //Content Style
        $this->start_controls_section(
            'acc_content_style',
            [
                'label' => __('Content', 'chakavak'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'acc_content_padding',
            [
                'label' => __('Content padding', 'chakavak'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'acc_content_typography',
                'selector' => '{{WRAPPER}} .chk-acc-1-item__text',
                'description' => __('Only when Content Type is equal to content.', 'chakavak'),
            ]
        );

        $this->add_responsive_control(
            'acc_content_alignment',
            [
                'label' => esc_html__('Text align', 'chakavak'),
                'type' => Controls_Manager::CHOOSE,
                'options' => chakavak_alignment(),
                'description' => __('Only when Content Type is equal to content.', 'chakavak'),
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item__text' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .chk-acc-1-item__image' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'acc_content_text_color',
            [
                'label' => __('Text color', 'chakavak'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .chk-acc-1-item__text' => 'color: {{VALUE}};',
                ],
                'description' => __('Only when Content Type is equal to content.', 'chakavak'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $migrated = isset($settings['__fa4_migrated']['icon_close']);
        if (!isset($settings['icon']) && !Icons_Manager::is_migration_allowed()) {
            $settings['select_default_icon'] = 'ti-arrow-down';
            $settings['select_active_icon'] = 'ti-arrow-up';
            $settings['toggle_align'] = $this->get_settings('toggle_align');
        }
        $is_new = empty($settings['icon']) && Icons_Manager::is_migration_allowed();
        $has_icon = (!$is_new || !empty($settings['toggle_default']['value']));
        $this->add_render_attribute('wrapper', [
            'class' => sprintf('chk-accordions-1 chk-accordions-1-icon-%s', $settings['toggle_align']),
            'id' => sprintf('chk-accordions-1-%s', esc_attr($this->get_id()))
        ]);

        $this->add_render_attribute('acc-item', 'class', [
            'chk-acc-1-item',
            'pos-relative',
            'z-1',
            $settings['acc_style']
        ]);

        if ($settings['acc_style'] == 's2') {
            $this->add_render_attribute('acc-item', 'class', 'chk-bg-before');
        }

        ?>
        <div class="<?php echo $this->get_name(); ?>-element chk-element">
            <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
                <?php if ($settings['acc_items']) : foreach ($settings['acc_items'] as $key => $acc) {
                    $acc_content_text = '';
                    if ($acc['acc_type'] == 'content') {
                        $acc_content_text = '<div class="chk-acc-1-item__text chk-classic-editor">' . do_shortcode($acc['acc_content']) . '</div>';
                    } elseif ($acc['acc_type'] == 'image' && $acc['acc_image']['url']) {
                        if ($acc['image_size'] == 'full') {
                            $imgUrl = Group_Control_Image_Size::get_attachment_image_src($acc['acc_image']['id'], 'full', $acc);
                            $imgSrcset = ' srcset="' . wp_get_attachment_image_srcset($acc['acc_image']['id']) . '"';
                            $imgSizes = ' sizes="' . wp_get_attachment_image_sizes($acc['acc_image']['id'], "full") . '"';
                        } else {
                            $imgUrl = Group_Control_Image_Size::get_attachment_image_src($acc['acc_image']['id'], 'image', $acc);
                            $imgSrcset = '';
                            $imgSizes = '';
                        }
                        if (!$imgUrl) {
                            $imgUrl = $acc['acc_image']['url'];
                        }
                        $image_html = '<div class="chk-acc-1-item__image">';
                        $image_html .= '<img src="' . $imgUrl . '" ' . $imgSizes . $imgSrcset . ' alt="' . esc_attr(Control_Media::get_image_alt($acc['acc_image'])) . '">';
                        $image_html .= '</div>';
                        $acc_content_text = $image_html;
                    } elseif ($acc['acc_type'] == 'section' && !empty($acc['acc_saved_section'])) {
                        $acc_content_text = '<div class="chk-acc-1-item__template">' . Plugin::$instance->frontend->get_builder_content_for_display($acc['acc_saved_section']) . '</div>';
                    }

                    $tab_count = $key + 1;
                    $tab_title_setting_key = $this->get_repeater_setting_key('tab_title', 'tabs', $key);
                    $this->add_render_attribute($tab_title_setting_key, [
                        'class' => ['chk-acc-1-item__head', 'flex-middle', 'pos-relative', 'z-1'],
                        'data-tab' => $tab_count,
                        'role' => 'tab',
                        'data-default' => $key + 1 == $settings['item_active'] ? 'yes' : ''
                    ]);
                    if ($settings['acc_style'] == 's1') {
                        $this->add_render_attribute($tab_title_setting_key, 'class', 'chk-bg-before');
                    }

                    ?>
                    <div <?php echo $this->get_render_attribute_string('acc-item'); ?>>
                        <div <?php echo $this->get_render_attribute_string($tab_title_setting_key); ?>>
                            <?php if ($has_icon) {
                                $this->render_toggle_icon($settings['toggle_align'] == 'start', $is_new, $migrated, $settings);
                            } ?>

                            <?php if (!empty($acc['acc_title'])) {
                                $title_class = 'chk-acc-1-item__title transition-all pos-relative z-1';
                                $title_tag = $settings['item_title_tag'];
                                echo '<' . $title_tag . ' class="' . esc_attr($title_class) . '">';
                                echo esc_html(esc_html($acc['acc_title']));
                                echo '</' . $title_tag . '>';
                            } ?>

                            <?php
                            if ($has_icon) {
                                $this->render_toggle_icon($settings['toggle_align'] == 'end', $is_new, $migrated, $settings);
                            } ?>

                        </div>

                        <div class="chk-acc-1-item__content pos-relative z-1">
                            <?php echo $acc_content_text; ?>
                        </div>

                    </div>

                    <?php
                }
                endif; ?>
            </div>

            <?php
            if (isset($settings['faq_schema']) && 'yes' === $settings['faq_schema']) {
                $json = [
                    '@context' => 'https://schema.org',
                    '@type' => 'FAQPage',
                    'mainEntity' => [],
                ];

                foreach ($settings['acc_items'] as $index => $item) {
                    $json['mainEntity'][] = [
                        '@type' => 'Question',
                        'name' => wp_strip_all_tags($item['acc_title']),
                        'acceptedAnswer' => [
                            '@type' => 'Answer',
                            'text' => $this->parse_text_editor($item['acc_content']),
                        ],
                    ];
                }
                ?>
                <script type="application/ld+json">
                    <?php echo wp_json_encode($json, JSON_UNESCAPED_UNICODE); ?>




                </script>
            <?php } ?>
        </div>
        <?php
    }

    protected function render_toggle_icon($is_start_aligned, $is_new, $migrated, $settings)
    {
        if ($is_start_aligned) {
            ?>
            <div class="chk-acc-1-item__toggle lh-0">
                <?php if ($is_new || $migrated) { ?>
                    <span class="chk-acc-1-item__toggle-down chk-acc-1-item__toggle-icon chk-icon transition-all">
                        <?php Icons_Manager::render_icon($settings['toggle_default']); ?>
                    </span>
                    <span class="chk-acc-1-item__toggle-up chk-acc-1-item__toggle-icon chk-icon transition-all">
                        <?php Icons_Manager::render_icon($settings['toggle_active']); ?>
                    </span>
                <?php } else { ?>
                    <i class="chk-acc-1-item__toggle-down chk-acc-1-item__toggle-icon chk-icon transition-all <?php echo esc_attr($settings['select_default_icon']); ?>"></i>
                    <i class="chk-acc-1-item__toggle-up chk-acc-1-item__toggle-icon chk-icon transition-all <?php echo esc_attr($settings['select_active_icon']); ?>"></i>
                <?php } ?>
            </div>
        <?php }
    }
}

Plugin::instance()->widgets_manager->register(new chk_Accordions_1());
