(function ($) {
    "use strict";

    function rtl_isotop() {
        if ($('body').hasClass("rtl")) {
            return false;
        } else {
            return true;
        }
    }

    function initCarouselSwiper($target) {
        var _default = {
            items_xl: 3,
            items_lg: 3,
            items_md: 2,
            items_sm: 2,
            items_xs: 1,
            space_between: 30,
            effect: 'slide',
            loop: 1,
            center_mode: 0,
            speed: 600,
            autoplay: 1,
            autoplay_delay: 6000,
            autoplay_hover: 0,
            navigation: 1,
            pagination: 1,
            pagination_type: 'bullets',
            dynamic_bullets: 0
        };
        var settings = $target.data('carousel');
        settings = $.extend(!0, _default, settings);

        //-- Autoplay
        var _autoplay = false;
        if (settings.autoplay) {
            _autoplay = {
                delay: settings.autoplay_delay,
                disableOnInteraction: false,
                pauseOnMouseEnter: settings.autoplay_hover,
            }
        }

        //-- Pagination
        var _pagination = false;
        if (settings.pagination) {
            _pagination = {
                el: $target.parents('.swiper-slider-wrapper').find('.swiper-pagination')[0],
                type: settings.pagination_type,
                clickable: true,
            }
        }

        //-- Navigation
        var _navigation = false;
        if (settings.navigation) {
            _navigation = {
                nextEl: $target.parents('.swiper-slider-wrapper').find('.swiper-nav-next')[0],
                prevEl: $target.parents('.swiper-slider-wrapper').find('.swiper-nav-prev')[0],
                hiddenClass: 'hidden',

            }
        }

        const swiper = new Swiper($target[0], {
            loop: settings.loop,
            spaceBetween: settings.space_between,
            autoplay: _autoplay,
            speed: settings.speed,
            grabCursor: false,
            centeredSlides: false,
            centeredSlidesBounds: true,
            effect: settings.effect,
            breakpoints: {
                0: {
                    slidesPerView: 1
                },
                320: {
                    slidesPerView: settings.items_xs
                },
                576: {
                    slidesPerView: settings.items_sm
                },
                768: {
                    slidesPerView: settings.items_md
                },
                1025: {
                    slidesPerView: settings.items_lg
                },
                1200: {
                    slidesPerView: settings.items_xl
                },

            },
            pagination: _pagination,
            navigation: _navigation,
            observer: true,
            observeParents: true,
            slideVisibleClass: 'item-active',
            watchSlidesVisibility: true,
        });

        if (settings.autoplay_hover && settings.autoplay) {
            $target.hover(function () {
                swiper.autoplay.stop();
            }, function () {
                swiper.autoplay.start();
            });
        }
    }


    /**
     * message box
     */
    let chkMessageBox = function ($scope) {
        $scope.find(".chk-message-box").each(function () {
            let selector = $(this),
                close = selector.find(".chk-message-box__close");
            close.on("click", function () {
                $scope.fadeOut();
            });
        });
    };

    /**
     * Brands
     */
    let chkBrands = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    }

    /**
     * Image Slider
     */
    let chkImageSlider = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    }

    /**
     * Icon Box Carousel 1
     */
    let chkIconBoxCarousel_1 = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    };

    /**
     * Brands
     */
    let chkIconBoxCarousel_2 = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    }

    /**
     * Icon Box Carousel 3
     */
    let chkIconBoxCarousel_3 = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    }

    /**
     * Accordion
     */
    let chkAccordion_1 = function ($scope) {
        $scope.find('.chk-accordions-1').each(function () {
            var selector = $(this),
                content = selector.find('.chk-acc-1-item__content'),
                header = selector.find('.chk-acc-1-item__head');

            header.off("click");

            header.each(function () {
                if ($(this).data('default') == 'yes') {
                    $(this).next().addClass('active').slideDown(300);
                    $(this).parent().addClass('current');
                }
            });

            header.on('click', function (e) {
                e.preventDefault();
                var $this = $(this);

                $this.next().toggleClass('active').slideToggle(300);
                $this.parent().toggleClass('current');
                content.not($this.next()).slideUp(300);
                header.not($this).parent().removeClass('current');
            });
        });
    };

    /**
     * Counter
     */
    let chkCounter_1 = function ($scope, $) {
        $scope.find(".chk-counter-1").each(function () {
            var counterUp = window.counterUp["default"];
            const counters = document.querySelectorAll(".chk-counter-number");
            counters.forEach(el => {
                var duration = el.getAttribute('data-duration');
                new Waypoint({
                    element: el,
                    handler: function () {
                        counterUp(el, {
                            duration: duration,
                            delay: 50
                        })
                        this.destroy()
                    },
                    offset: 'bottom-in-view',
                })
            });
        });
    };

    /**
     * Portfolio carousel
     */
    let chkPortfolioCarousel = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    }

    /**
     * Portfolio Grid isotope
     */
    let chkPortfolioGrid = function ($scope, $) {
        $scope.find(".chk-portfolio-grid").each(function () {
            var $this = $(this),
                $isoGrid = $this.children(".chk-portfolio-grid__items"),
                $btns = $this.children(".chk-filter__items"),
                is_rtl = $this.data("rtl");
            $this.imagesLoaded(function () {
                var $grid = $isoGrid.isotope({
                    itemSelector: ".chk-prtfolio-item__wrap",
                    percentPosition: true,
                    originLeft: rtl_isotop(),
                    masonry: {
                        columnWidth: ".chk-prtfolio-item__wrap",
                    },
                });

                $btns.on("click", ".chk-filter__item-link", function () {
                    var filterValue = $(this).attr("data-filter");
                    $grid.isotope({
                        filter: filterValue,
                        originLeft: rtl_isotop(),
                    });
                });

                $btns.each(function (i, btns) {
                    var btns = $(btns);
                    btns.on("click", ".chk-filter__item-link", function () {
                        btns.find(".is-checked").removeClass("is-checked");
                        $(this).addClass("is-checked");
                    });
                });
            });
        });
    }

    /**
     * Contact form 7
     */
    let chkContactForm = function ($scope, $) {
        if ('undefined' == typeof $scope)
            return;
        var cf7SelectFields = $scope.find('select:not([multiple])'),
            cf7Loader = $scope.find('span.ajax-loader');
        cf7SelectFields.wrap("<span class='chk-cf7__select-custom'></span>");
        cf7Loader.wrap("<div class='chk-cf7__loader-active'></div>");
        var wpcf7event = document.querySelector('.wpcf7');

        if (null !== wpcf7event) {
            wpcf7event.addEventListener('wpcf7submit', function (event) {
                var cf7ErrorFields = $scope.find('.wpcf7-not-valid-tip');
                cf7ErrorFields.wrap("<span class='chk-cf7__alert'></span>");
            }, false);
        }
    };

    /**
     * Social Teams
     */
    let chkTeamSocialToggle_1 = function ($scope, $) {
        $scope.find('.chk-team-1__social-toggle').on("click", function () {
            $(this).parent().toggleClass("active");
        });
    };

    /**
     * Social team group carousel
     */
    let chkTeamCarousel_1 = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    };

    /**
     * Tabs
     */
    let chkTabs_1 = function ($scope, $) {
        $scope.find(".chk-tabs-1").each(function () {

            var selector = $(this),
                tabs = selector.find(".chk-tabs-1__nav-item"),
                content = selector.find(".chk-tabs-1__content");

            tabs.first().addClass("current");
            content.first().addClass("current").show();

            tabs.on("click", function (e) {
                e.preventDefault();
                if ($(this).hasClass("current")) return false;
                var tab_id = $(this).attr("data-tab");
                $(this).siblings().removeClass("current");
                $(this).parents(".chk-tabs-1").find(".chk-tabs-1__content").removeClass("current").hide();
                $(this).addClass("current");
                $("#" + tab_id).addClass("current").fadeIn(500);
            });

        });
    };

    /**
     * progress bar
     */
    let chkLineProgress = function () {
        $('.chk-progress__line').each(function () {
            var pos_y = $(this).offset().top;
            var value = $(this).find(".chk-pline-size").data('percent');
            var topOfWindow = $(window).scrollTop();
            if (pos_y < topOfWindow + 900) {
                $(this).find(".chk-pline-size").css({
                    'width': value
                }, "slow");
            }
        });
    }

    let chkCircleProgress = function () {
        $('.chk-progress__circle').each(function () {
            var bar_color = $(this).data('color');
            var bar_hei = $(this).data('height');
            var bar_size = $(this).data('size');
            var pos_y = $(this).offset().top;
            var topOfWindow = $(window).scrollTop();
            if (pos_y < topOfWindow + 900) {
                $(this).find('.chk-pcircle-bar').easyPieChart({
                    barColor: bar_color,
                    trackColor: false,
                    scaleColor: false,
                    lineCap: 'square',
                    lineWidth: bar_hei,
                    size: bar_size,
                    animate: 1000,
                    onStart: $.noop,
                    onStop: $.noop,
                    onStep: function (from, to, percent) {
                        $(this.el).find('.chk-pcircle-percent').text(Math.round(percent));
                    }
                });
            }
        });
    }

    let chkProgressBar = function () {
        chkLineProgress();
        chkCircleProgress();
        $(window).on('scroll', function () {
            chkLineProgress();
            chkCircleProgress();
        });
    }

    /**
     * Testimonial1
     */
    let chkTestimonialCarousel_1 = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    };

    /**
     * Posts Carousel
     */
    let chkPostsCarousel = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    };

    /**
     * Posts Grid isotope
     */
    let chkPostsGrid = function ($scope, $) {
        $scope.find(".chk-posts-grid").each(function () {
            var $this = $(this),
                $isoGrid = $this.children(".chk-posts-grid__items"),
                $btns = $this.children(".chk-filter__items"),
                is_rtl = $this.data("rtl");
            $this.imagesLoaded(function () {
                var $grid = $isoGrid.isotope({
                    itemSelector: ".chk-posts-item__wrap",
                    percentPosition: true,
                    originLeft: rtl_isotop(),
                    masonry: {
                        columnWidth: ".chk-posts-item__wrap",
                    },
                });

                $btns.on("click", ".chk-filter__item-link", function () {
                    var filterValue = $(this).attr("data-filter");
                    $grid.isotope({
                        filter: filterValue,
                        originLeft: rtl_isotop(),
                    });
                });

                $btns.each(function (i, btns) {
                    var btns = $(btns);
                    btns.on("click", ".chk-filter__item-link", function () {
                        btns.find(".is-checked").removeClass("is-checked");
                        $(this).addClass("is-checked");
                    });
                });
            });
        });
    }

    /**
     * Animated Text
     */
    let chkAnimatedText = function ($scope, $) {
        let $animated_text = $scope.find(".chk-animated-text");
        if (!$animated_text.length) {
            return;
        }
        $animated_text.each(function () {
            var $this = $(this),
                $heading = $scope.find(".chk-animated-text > *"),
                strings = $this.find(".chk-animated-text__strings"),
                anim = $this.data("anim"),
                speed = $this.data("speed"),
                delay = $this.data("delay"),
                cursor = !!$this.data("cursor"),
                loop = !!$this.data("loop"),
                animatedText = $this.data("animated-text"),
                animatedTxt = animatedText.split("@@");

            if ("typing" === anim) {
                strings.typed({
                    strings: animatedTxt,
                    typeSpeed: speed,
                    startDelay: delay,
                    showCursor: cursor,
                    loop: loop,
                });
            } else {
                strings.Morphext({
                    animation: anim,
                    separator: "@@",
                    speed: delay,
                });
            }

            $($heading).animate(
                {
                    easing: "slow",
                    opacity: 1,
                },
                500
            );
        });
    };

    /**
     * Image box1 carousel
     */
    let chkImageBoxCarousel_1 = function ($scope, $) {
        var $carousel = $scope.find('.init-carousel-swiper');
        initCarouselSwiper($carousel);
    }

    /**
     * CountDown
     */
    let ChkCountdown = function ($scope, $) {
        $scope.find(".chk-countdown").each(function (item, index) {
            var $this = $(this),
                year = $this.find(".chk-countdown__year"),
                month = $this.find(".chk-countdown__month"),
                week = $this.find(".chk-countdown__week"),
                day = $this.find(".chk-countdown__day"),
                hour = $this.find(".chk-countdown__hour"),
                min = $this.find(".chk-countdown__minute"),
                sec = $this.find(".chk-countdown__second"),
                text = $this.data("text"),
                standardCountdown = $this.data("standard-countdown"),
                mesg = $this.data("message"),
                link = $this.data("link"),
                time = $this.data("time"),
                data_text_year = $this.data("text-year"),
                data_text_month = $this.data("text-month"),
                data_text_week = $this.data("text-week"),
                data_text_day = $this.data("text-day"),
                data_text_hour = $this.data("text-hour"),
                data_text_minute = $this.data("text-minute"),
                data_text_second = $this.data("text-second"),
                data_valid_redirect = $this.data("valid-redirect"),
                data_edit_mode = $this.data("edit-mode");


            $this.countdown(time).on("update.countdown", function (e) {
                var m = e.strftime("%m"),
                    w = e.strftime("%w"),
                    Y = Math.floor(m / 12),
                    m = m % 12,
                    w = w % 4;

                function addZero(val) {
                    if (val < 10) {
                        return "0" + val;
                    }
                    return val;
                }

                if (standardCountdown === "yes") {
                    day.html(e.strftime("%D"));
                } else {
                    year.html(addZero(Y));
                    month.html(addZero(m));
                    week.html("0" + w);
                    day.html(e.strftime("%d"));
                }

                hour.html(e.strftime("%H"));
                min.html(e.strftime("%M"));
                sec.html(e.strftime("%S"));

                if (text === "yes") {
                    if (standardCountdown === "yes") {
                        day.next().html(data_text_day);
                    } else {
                        year.next().html(data_text_year);
                        month.next().html(data_text_month);
                        week.next().html(data_text_week);
                        day.next().html(data_text_day);
                    }
                    hour.next().html(data_text_hour);
                    min.next().html(data_text_minute);
                    sec.next().html(data_text_second);
                }
            })
                .on("finish.countdown", function (e) {
                    $this.children().remove();
                    if (mesg) {
                        $this.append('<div class="chk-countdown__message">' + mesg + "</div>");
                    } else if (link && elementorFrontend.isEditMode()) {
                        $this.append('<h5>' + data_edit_mode + '</h5>');
                    } else if (link) {
                        window.location.href = link;
                    } else {
                        $this.append('<h5>' + data_valid_redirect + '</h5>');
                    }
                });
        });
    };


    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_messagebox.default", chkMessageBox);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_brands.default", chkBrands);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_icon_box_carousel_1.default", chkIconBoxCarousel_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_icon_box_carousel_2.default", chkIconBoxCarousel_2);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_icon_box_carousel_3.default", chkIconBoxCarousel_3);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_accordions_1.default", chkAccordion_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_portfolio_carousel.default", chkPortfolioCarousel);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_portfolio_grid.default", chkPortfolioGrid);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_counter_1.default", chkCounter_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_cf7.default", chkContactForm);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_team_single_1.default", chkTeamSocialToggle_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_team_carousel_1.default", function ($scope, $) {
            chkTeamSocialToggle_1($scope, $);
            chkTeamCarousel_1($scope, $);
        });
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_team_grid_1.default", chkTeamSocialToggle_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_tabs_1.default", chkTabs_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_progress_bar.default", chkProgressBar);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_testimonials_carousel_1.default", chkTestimonialCarousel_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_posts_carousel.default", chkPostsCarousel);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_posts_grid.default", chkPostsGrid);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_animated_text.default", chkAnimatedText);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_image_box_carousel_1.default", chkImageBoxCarousel_1);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_countdown.default", ChkCountdown);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_image_slider.default", chkImageSlider);


    })

})(jQuery);