<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
if (class_exists('CSF')) {
    $prefix = 'chakavak';
    CSF::createSection($chakavakThemeOptions, [
        'title' => esc_html__('Typography', 'chakavak'),
        'id' => 'typography_opts',
        'icon' => 'ai-typography',
        'fields' => [
            [
                'id' => 'typography_switch',
                'type' => 'switcher',
                'default' => false,
                'title' => esc_html__('Typography Customize?', 'chakavak'),
            ],
            [
                'id' => 'body_typography',
                'type' => 'typography',
                'title' => esc_html__('Body', 'chakavak'),
                'subtitle' => esc_html__('Specify the body font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'type' => 'subheading',
                'content' => esc_html__('Headings', 'chakavak'),
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'id' => 'h1_typography',
                'type' => 'typography',
                'title' => esc_html__('H1 Tag', 'chakavak'),
                'subtitle' => esc_html__('Specify the H1 font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'id' => 'h2_typography',
                'type' => 'typography',
                'title' => esc_html__('H2 Tag', 'chakavak'),
                'subtitle' => esc_html__('Specify the H2 font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'id' => 'h3_typography',
                'type' => 'typography',
                'title' => esc_html__('H3 Tag', 'chakavak'),
                'subtitle' => esc_html__('Specify the H3 font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'id' => 'h4_typography',
                'type' => 'typography',
                'title' => esc_html__('H4 Tag', 'chakavak'),
                'subtitle' => esc_html__('Specify the H4 font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'id' => 'h5_typography',
                'type' => 'typography',
                'title' => esc_html__('H5 Tag', 'chakavak'),
                'subtitle' => esc_html__('Specify the H5 font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
            [
                'id' => 'h6_typography',
                'type' => 'typography',
                'title' => esc_html__('H6 Tag', 'chakavak'),
                'subtitle' => esc_html__('Specify the H6 font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => true,
                'line_height' => true,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['typography_switch', '==', 'true'],
            ],
        ],
    ]);
}
