<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    $prefix = 'chakavak';

    /*CSS*/
    CSF::createSection($chakavakThemeOptions, array(
        'id' => 'css_opts', // Set a unique slug-like ID
        'title' => esc_html__('Css Code', 'chakavak'),
        'icon' => 'ai-css3',
        'fields' => [
            [
                'id' => 'css_all_screen',
                'type' => 'code_editor',
                'title' => esc_html__('All screens', 'chakavak'),
                'subtitle' => esc_html__('Load CSS in all Screen', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'css',
                ],
            ],
            [
                'id' => 'css_desktop',
                'type' => 'code_editor',
                'title' => esc_html__('Desktop to the top', 'chakavak'),
                'subtitle' => esc_html__('Loading CSS from 1025px up', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'css',
                ],
            ],
            [
                'id' => 'css_tablet',
                'type' => 'code_editor',
                'title' => esc_html__('Tablet to the top', 'chakavak'),
                'subtitle' => esc_html__('Loading CSS from 768px up', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'css',
                ],
            ],
            [
                'id' => 'css_mobile',
                'type' => 'code_editor',
                'title' => esc_html__('Mobile to the top', 'chakavak'),
                'subtitle' => esc_html__('Load CSS up to 767 pixels down', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'css',
                ],
            ],
        ]
    ));

    /*JS*/
    CSF::createSection($chakavakThemeOptions, array(
        'id' => 'js_opts', // Set a unique slug-like ID
        'title' => esc_html__('Script Code', 'chakavak'),
        'icon' => 'ai-javascript',
        'fields' => [
            [
                'id' => 'js_head_code',
                'type' => 'code_editor',
                'title' => esc_html__('Head Scripts', 'chakavak'),
                'subtitle' => esc_html__('Add custom scripts inside HEAD tag.Do not include the <script></script> tag.', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'javascript',
                ],
                'default' => '(function ($) {
                "use strict";
                $(document).ready(
                function() {
                // do stuff
                });',
            ],
            [
                'id' => 'js_start_body_code',
                'type' => 'code_editor',
                'title' => esc_html__('Start Body', 'chakavak'),
                'subtitle' => esc_html__('Add custom scripts inside Start BODY tag.Do not include the <script></script> tag.', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'javascript',
                ],
            ],
            [
                'id' => 'js_end_body_code',
                'type' => 'code_editor',
                'title' => esc_html__('Before Body close.', 'chakavak'),
                'subtitle' => esc_html__('Add custom scripts inside colse BODY tag.Do not include the <script></script> tag.', 'chakavak'),
                'settings' => [
                    'theme' => 'shadowfox',
                    'mode' => 'javascript',
                ],
                'default' => '',
            ],
        ]
    ));
}
