<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, [
        'id' => 'page_header_opts', // Set a unique slug-like ID
        'title' => esc_html__('Page Header', 'chakavak'),
        'icon' => 'ai-header-page',
        'fields' => [
            [
                'id' => 'pheader_switch',
                'type' => 'switcher',
                'default' => true,
                'title' => esc_html__('Activate Page Header', 'chakavak'),
            ],

            [
                'id' => 'pheader_title_tag',
                'type' => 'select',
                'title' => esc_html__('Title Tag', 'chakavak'),
                'subtitle' => esc_html__('Select Title HTML Tag', 'chakavak'),
                'placeholder' => esc_html__('Select an option', 'chakavak'),
                'options' => [
                    'h1' => esc_html__('Tag H1', 'chakavak'),
                    'h2' => esc_html__('Tag H2', 'chakavak'),
                    'h3' => esc_html__('Tag H3', 'chakavak'),
                    'h4' => esc_html__('Tag H4', 'chakavak'),
                ],
                'default' => 'h2',
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            [
                'id' => 'page_header_align',
                'type' => 'button_set',
                'title' => esc_html__('Text Align', 'chakavak'),
                'options' => [
                    'text-left' => esc_html__('Left', 'chakavak'),
                    'text-center' => esc_html__('Center', 'chakavak'),
                    'text-right' => esc_html__('Right', 'chakavak'),
                ],
                'default' => 'text-center',
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            [
                'id' => 'page_header_img',
                'type' => 'media',
                'title' => esc_html__('Background Page Header', 'chakavak'),
                'library' => 'image',
                'preview' => true,
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            [
                'id' => 'pheader_bg_color',
                'type' => 'color',
                'title' => esc_html__('Background Color', 'chakavak'),
                'dependency' => ['pheader_switch', '==', 'true'],
                'output' => '.chk-page-header',
                'output_mode' => 'background',
            ],

            [
                'id' => 'pheader_overlay_color',
                'type' => 'background',
                'title' => esc_html__('Overlay Color', 'chakavak'),
                'background_gradient' => true,
                'background_image' => false,
                'background_position' => false,
                'background_repeat' => false,
                'background_attachment' => false,
                'background_size' => false,
                'dependency' => ['pheader_switch', '==', 'true'],
                'default' => [
                    'background-color' => '',
                    'background-gradient-color' => '',
                    'background-gradient-direction' => 'to bottom',
                ],
                'output' => '.chk-page-header:before',
            ],

            [
                'id' => 'pheader_title_color',
                'type' => 'color',
                'title' => esc_html__('Title Color', 'chakavak'),
                'output' => '.chk-page-header__title ',
                'output_mode' => 'color',
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            [
                'id' => 'pheader_typography',
                'type' => 'typography',
                'title' => esc_html__('Typography', 'chakavak'),
                'subtitle' => esc_html__('Specify the Page header font properties.', 'chakavak'),
                'exclude' => 'safe',
                'text_align' => false,
                'text_transform' => false,
                'font_size' => false,
                'line_height' => false,
                'letter_spacing' => false,
                'color' => false,
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            //breadcrumb

            [
                'type' => 'subheading',
                'content' => esc_html__('Breadcrumb', 'chakavak'),
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            [
                'id' => 'breadcrumbs',
                'type' => 'switcher',
                'title' => esc_html__('Activate breadcrumbs', 'chakavak'),
                'dependency' => ['pheader_switch', '==', 'true'],
            ],

            [
                'id' => 'breadcrumbs_type',
                'type' => 'select',
                'title' => esc_html__('Breadcrumb Type', 'chakavak'),
                'subtitle' => esc_html__('If you have chosen Breadcrumbs Yoast or Rank Meth, you must activate it from the plugin settings panel and site path section.', 'chakavak'),
                'options' => array(
                    'default' => esc_html__('default', 'chakavak'),
                    'yoast' => esc_html__('Yoast', 'chakavak'),
                    'rank-math' => esc_html__('Rank Math', 'chakavak'),
                ),
                'default' => 'default',
                'dependency' => ['pheader_switch|breadcrumbs', '==|==', 'true|true',],
            ],

            [
                'id' => 'breadcrumbs_color',
                'type' => 'color',
                'title' => esc_html__('Breadcrumbs Color', 'chakavak'),
                'output' => '.chk-breadcrumbs__list',
                'output_mode' => 'color',
                'dependency' => ['pheader_switch|breadcrumbs', '==|==', 'true|true',],
            ],

            [
                'id' => 'breadcrumbs_typography',
                'type' => 'typography',
                'title' => esc_html__('Typography', 'chakavak'),
                'subtitle' => esc_html__('Specify the breadcrumbs font properties.', 'chakavak'),
                'text_align' => false,
                'text_transform' => false,
                'font_size' => false,
                'line_height' => false,
                'letter_spacing' => false,
                'color' => false,
                'exclude' => 'safe',
                'google',
                'dependency' => ['pheader_switch|breadcrumbs', '==|==', 'true|true',],
            ],

            /*Min Height*/
            [
                'type' => 'subheading',
                'content' => esc_html__('Height & Font Size', 'chakavak'),
                'dependency' => ['pheader_switch', '==', 'true'],
            ],
            [
                'id' => 'pheader_height_group',
                'type' => 'fieldset',
                'title' => esc_html__('Page Header height', 'chakavak'),
                'dependency' => ['pheader_switch', '==', 'true'],
                'fields' => [
                    [
                        'id' => 'pheader_height_desktop',
                        'type' => 'spinner',
                        'title' => esc_html__('Min Height Desktop', 'chakavak'),
                        'subtitle' => esc_html__('From at least 1025px to up . min:100 , max:500', 'chakavak'),
                        'unit' => 'px',
                        'min' => 100,
                        'max' => 500,
                        'step' => 1,
                    ],
                    [
                        'id' => 'pheader_height_tablet',
                        'type' => 'spinner',
                        'title' => esc_html__('Min Height Tablet', 'chakavak'),
                        'subtitle' => esc_html__('From at least 768px to up . min:100 , max:500', 'chakavak'),
                        'unit' => 'px',
                        'min' => 100,
                        'max' => 500,
                        'step' => 1,
                    ],
                    [
                        'id' => 'pheader_height_mobile',
                        'type' => 'spinner',
                        'title' => esc_html__('Min Height Mobile', 'chakavak'),
                        'subtitle' => esc_html__('Up to a maximum 767px.min:50 , max:400', 'chakavak'),
                        'unit' => 'px',
                        'min' => 50,
                        'max' => 400,
                        'step' => 1,
                    ],
                ]
            ],
            [
                'id' => 'ptitle_font_size_group',
                'type' => 'fieldset',
                'title' => esc_html__('Page title font size', 'chakavak'),
                'dependency' => ['pheader_switch', '==', 'true'],
                'fields' => [
                    [
                        'id' => 'ptitle_size_desktop',
                        'type' => 'spinner',
                        'title' => esc_html__('Font size in Desktop', 'chakavak'),
                        'subtitle' => esc_html__('From at least 1025px to up', 'chakavak'),
                        'unit' => 'px',
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                    [
                        'id' => 'ptitle_size_tablet',
                        'type' => 'spinner',
                        'title' => esc_html__('Font size in Tablet', 'chakavak'),
                        'subtitle' => esc_html__('From at least 768px to up', 'chakavak'),
                        'unit' => 'px',
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                    [
                        'id' => 'ptitle_size_mobile',
                        'type' => 'spinner',
                        'title' => esc_html__('Font size in Mobile', 'chakavak'),
                        'subtitle' => esc_html__('Up to a maximum 767px', 'chakavak'),
                        'unit' => 'px',
                        'min' => 10,
                        'max' => 40,
                        'step' => 1,
                    ],
                ]
            ]
        ]
    ]);
}
