<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, [
        'id' => 'other_opts', // Set a unique slug-like ID
        'title' => esc_html__('Other Options', 'chakavak'),
        'icon' => 'ai-settings',
        'fields' => [

            [
                'id' => 'container_width',
                'type' => 'spinner',
                'title' => esc_html__('Container Width', 'chakavak'),
                'subtitle' => esc_html__('Container width from 1200px resolution and up', 'chakavak'),
                'unit' => 'px',
                'min' => 500,
                'max' => 2000,
                'step' => 1,
            ],

            [
                'id' => 'sw_classic_editor',
                'type' => 'switcher',
                'title' => esc_html__('Active Classic editor', 'chakavak'),
                'default' => false,
            ],
            [
                'id' => 'sidebar_sticky',
                'type' => 'switcher',
                'title' => esc_html__('Sidebar Sticky ?', 'chakavak'),
                'default' => true
            ],

            [
                'id' => 'social_sharing',
                'type' => 'checkbox',
                'title' => esc_html__('List of sharing post', 'chakavak'),
                'default' => ['linkedin', 'telegram', 'whatsapp'],
                'inline' => true,
                'options' => [
                    'facebook' => esc_html__('Facebook', 'chakavak'),
                    'twitter' => esc_html__('Twitter', 'chakavak'),
                    'linkedin' => esc_html__('Linkedin', 'chakavak'),
                    'telegram' => esc_html__('Telegram', 'chakavak'),
                    'whatsapp' => esc_html__('Whatsapp', 'chakavak'),
                ],
            ],

        ]
    ]);
}
