<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, array(
        'id' => 'maintenance_opts', // Set a unique slug-like ID
        'title' => esc_html__('Maintenance Page', 'chakavak'),
        'icon' => 'ai-maintenance',
        'fields' => [
            [
                'id' => 'enable_maintenance',
                'type' => 'switcher',
                'title' => esc_html__('Enable maintenance', 'chakavak'),
                'default' => false,
            ],

            [
                'id' => 'maintenance_logo',
                'type' => 'media',
                'library' => 'image',
                'preview' => true,
                'title' => esc_html__('Logo', 'chakavak'),
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/favicon.png',
                ],
                'dependency' => [
                    'enable_maintenance', '==', 'true',
                ],
            ],

            [
                'id' => 'maintenance_main_title',
                'type' => 'text',
                'title' => esc_html__('Main title', 'chakavak'),
                'default' => esc_html__('We’ll be back soon!', 'chakavak'),
                'dependency' => [
                    'enable_maintenance', '==', 'true',
                ],
            ],

            [
                'id' => 'maintenance_desc',
                'type' => 'wp_editor',
                'title' => esc_html__('Description', 'chakavak'),
                'default' => esc_html__('We apologize for the inconvenience.We are currently making some changes and updates to our website.If you need assistance, please contact us at Info@chakavak.agancy . We will be back soon!', 'chakavak'),
                'tinymce' => true,
                'quicktags' => true,
                'media_buttons' => false,
                'height' => '250px',
                'dependency' => [
                    'enable_maintenance', '==', 'true',
                ],
            ],

            [
                'id' => 'maintenance_social',
                'type' => 'group',
                'title' => esc_html__('Social Network', 'chakavak'),
                'dependency' => [
                    'enable_maintenance', '==', 'true',
                ],
                'fields' => [
                    [
                        'id' => 'maintenance_social_icon',
                        'type' => 'select',
                        'title' => esc_html__('Select Icon', 'chakavak'),
                        'options' => [
                            'logo-facebook' => esc_html__('Facebook', 'chakavak'),
                            'logo-twitter' => esc_html__('Twitter', 'chakavak'),
                            'logo-x' => esc_html__('X', 'chakavak'),
                            'logo-linkedin' => esc_html__('Linkedin', 'chakavak'),
                            'logo-instagram' => esc_html__('Instagram', 'chakavak'),
                            'logo-telegram' => esc_html__('Telegram', 'chakavak'),
                            'logo-dribbble' => esc_html__('Dribbble', 'chakavak'),
                            'phone-call' => esc_html__('Phone', 'chakavak'),
                        ],
                    ],
                    [
                        'id' => 'maintenance_social_link',
                        'type' => 'text',
                        'title' => esc_html__('Link', 'chakavak'),
                    ]
                ]
            ],
        ]
    ));
}
