<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {
    $prefix = 'chakavak';
    $url_img = get_template_directory_uri() . '/inc/backend/assets/images/loader/';
    CSF::createSection($chakavakThemeOptions, [
        'id' => 'site_loader_opts', // Set a unique slug-like ID
        'title' => esc_html__('Site Loader', 'chakavak'),
        'icon' => 'ai-preloader',
        'fields' => [
            [
                'id' => 'display_loader',
                'type' => 'switcher',
                'title' => esc_html__('Site Loader', 'chakavak'),
                'subtitle' => esc_html__('Turn on to show the icon/images Loader animation before Site Load.', 'chakavak'),
                'default' => false
            ],
            [
                'id' => 'loader_bg_color',
                'type' => 'color',
                'title' => esc_html__('Loader Background Color', 'chakavak'),
                'default' => '#ffffff',
                'subtitle' => esc_html__('Choose Loader Background Color', 'chakavak'),
                'dependency' => ['display_loader', '==', 'true'],
            ],
            [
                'id' => 'loader_color',
                'type' => 'color',
                'title' => esc_html__('Loader Color', 'chakavak'),
                'default' => '#1D4ED8',
                'subtitle' => esc_html__('Choose Loader Color', 'chakavak'),
                'dependency' => ['display_loader', '==', 'true'],
            ],
            [
                'id' => 'loader_style',
                'type' => 'button_set',
                'title' => __('Loader Setting', 'chakavak'),
                'subtitle' => __('Select Loader Display Type.', 'chakavak'),
                'dependency' => ['display_loader', '==', 'true'],
                'options' => [
                    '1' => __('Default', 'chakavak'),
                    '2' => __('Loader', 'chakavak'),
                    '3' => __('Custom', 'chakavak'),
                ],
                'default' => '1'
            ],
            [
                'id' => 'loader_type',
                'class' => 'loader_images',
                'type' => 'image_select',
                'title' => esc_html__('Loader Style', 'chakavak'),
                'dependency' => ['display_loader|loader_style', '==|==', 'true|2',],
                'subtitle' => esc_html__('Select the design variation that you want to use for site.', 'chakavak'),
                'options' => [
                    '1' => $url_img . 'loading-1.jpg',
                    '2' => $url_img . 'loading-2.jpg',
                    '3' => $url_img . 'loading-3.jpg',
                    '4' => $url_img . 'loading-4.jpg',
                    '5' => $url_img . 'loading-5.jpg',
                    '6' => $url_img . 'loading-6.jpg',
                    '7' => $url_img . 'loading-7.jpg',
                    '8' => $url_img . 'loading-8.jpg',
                ],
                'default' => '1'
            ],
            [
                'id' => 'loader_image',
                'type' => 'media',
                'url' => true,
                'title' => esc_html__('Add GIF image for loader', 'chakavak'),
                'read-only' => false,
                'dependency' => ['display_loader|loader_style', '==|==', 'true|3',],
                'default' => [
                    'url' => get_template_directory_uri() . '/assets/images/favicon.png',
                    'preview' => true,
                ],
                'subtitle' => esc_html__('Upload Loader GIF image for your Website.', 'chakavak'),
            ],
        ]
    ]);
}
