<?php
if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}
if (class_exists('CSF')) {
    CSF::createSection($chakavakThemeOptions, [
        'title' => esc_html__('Posts', 'chakavak'),
        'id' => 'posts_opts',
        'icon' => 'ai-articles',
    ]);

    CSF::createSection($chakavakThemeOptions, [
        'title' => esc_html__('Archive', 'chakavak'),
        'parent' => 'posts_opts',
        'fields' => [
            [
                'id' => 'posts_layout',
                'type' => 'image_select',
                'title' => esc_html__('Posts Layout', 'chakavak'),
                'options' => [
                    'full-content' => CHAKAVAK_BACKEND_ASSETS . 'images/full-width.png',
                    'left-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/left-sidebar.png',
                    'right-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/right-sidebar.png',
                ],
                'default' => 'left-sidebar',
            ],

            [
                'id' => 'posts_card_layout',
                'type' => 'image_select',
                'title' => esc_html__('Posts card layout', 'chakavak'),
                'options' => [
                    'classic' => CHAKAVAK_BACKEND_ASSETS . 'images/classic.png',
                    'grid' => CHAKAVAK_BACKEND_ASSETS . 'images/grid.png',
                    'list' => CHAKAVAK_BACKEND_ASSETS . 'images/list.png',
                ],
                'default' => 'grid',
            ],

            [
                'id' => 'posts_style',
                'type' => 'select',
                'title' => esc_html__('Posts Style', 'chakavak'),
                'default' => 'grid',
                'options' => [
                    'grid' => esc_attr__('Grid Normal', 'chakavak'),
                    'masonry' => esc_attr__('Grid Masonry', 'chakavak'),
                ],
                'dependency' => ['posts_card_layout', '==', 'grid'],
            ],

            [
                'id' => 'posts_columns_desktop',
                'type' => 'select',
                'title' => esc_html__('Columns in desktop', 'chakavak'),
                'default' => '3',
                'subtitle' => esc_html__('Choose the default columns on the Desktop for the archive and blog page.', 'chakavak'),
                'options' => [
                    '1' => esc_attr__('1 Columns', 'chakavak'),
                    '2' => esc_attr__('2 Columns', 'chakavak'),
                    '3' => esc_attr__('3 Columns', 'chakavak'),
                    '4' => esc_attr__('4 Columns', 'chakavak'),
                ],
                'dependency' => ['posts_card_layout', '==', 'grid'],
            ],

            [
                'id' => 'posts_columns_tablet',
                'type' => 'select',
                'title' => esc_html__('Columns in tablet', 'chakavak'),
                'default' => '2',
                'subtitle' => esc_html__('Choose the default columns on the tablet for the archive and blog page.', 'chakavak'),
                'options' => [
                    '1' => esc_attr__('1 Columns', 'chakavak'),
                    '2' => esc_attr__('2 Columns', 'chakavak'),
                    '3' => esc_attr__('3 Columns', 'chakavak'),
                ],
                'dependency' => ['posts_card_layout', '==', 'grid'],
            ],

            [
                'id' => 'posts_columns_mobile',
                'type' => 'select',
                'title' => esc_html__('Columns in mobile', 'chakavak'),
                'default' => '1',
                'subtitle' => esc_html__('Choose the default columns on the mobile for the archive and blog page.', 'chakavak'),
                'options' => [
                    '1' => esc_attr__('1 Columns', 'chakavak'),
                    '2' => esc_attr__('2 Columns', 'chakavak'),
                ],
                'dependency' => ['posts_card_layout', '==', 'grid'],
            ],

            [
                'id' => 'archive_posts_desc',
                'type' => 'select',
                'title' => esc_html__('Archive description position', 'chakavak'),
                'options' => [
                    'top-desc' => esc_html__('Top of the page ', 'chakavak'),
                    'bottom-desc' => esc_html__('Bottom of the page ', 'chakavak'),
                ],
                'default' => 'bottom-desc',
            ],

            [
                'type' => 'subheading',
                'content' => esc_html__('Post Card', 'chakavak'),
            ],

            [
                'id' => 'post_card_title_tag',
                'type' => 'select',
                'title' => esc_html__('Title Tag', 'chakavak'),
                'subtitle' => esc_html__('Select Title HTML Tag', 'chakavak'),
                'placeholder' => esc_html__('Select an option', 'chakavak'),
                'options' => [
                    'h1' => esc_html__('Tag H1', 'chakavak'),
                    'h2' => esc_html__('Tag H2', 'chakavak'),
                    'h3' => esc_html__('Tag H3', 'chakavak'),
                    'h4' => esc_html__('Tag H4', 'chakavak'),
                    'h5' => esc_html__('Tag H5', 'chakavak'),
                    'strong' => esc_html__('Tag strong', 'chakavak'),
                    'span' => esc_html__('Tag span', 'chakavak'),
                ],
                'default' => 'h2',
            ],

            [
                'id' => 'post_card_title_inline',
                'type' => 'switcher',
                'default' => true,
                'title' => esc_html__('Single line title', 'chakavak'),
            ],

            [
                'id' => 'post_card_entry_meta',
                'type' => 'checkbox',
                'title' => esc_html__('Entry Meta', 'chakavak'),
                'default' => ['date', 'author', 'comm'],
                'inline' => true,
                'options' => [
                    'date' => esc_html__('Date', 'chakavak'),
                    'author' => esc_html__('Author', 'chakavak'),
                    'comm' => esc_html__('Comment', 'chakavak'),
                ],
            ],

            [
                'id' => 'post_card_show_excerpt',
                'type' => 'switcher',
                'title' => esc_attr__('Show Excerpt', 'chakavak'),
                'default' => true,
            ],

            [
                'id' => 'post_card_excerpt_length',
                'type' => 'number',
                'title' => esc_attr__('Excerpt Length', 'chakavak'),
                'default' => '150',
                'dependency' => ['post_card_show_excerpt', '==', 'true'],
            ],

        ]
    ]);


    CSF::createSection($chakavakThemeOptions, [
        'title' => esc_html__('Single Post', 'chakavak'),
        'parent' => 'posts_opts',
        'fields' => [
            [
                'id' => 'single_post_layout',
                'type' => 'image_select',
                'title' => esc_html__('Post Layout', 'chakavak'),
                'options' => [
                    'full-content' => CHAKAVAK_BACKEND_ASSETS . 'images/full-width.png',
                    'left-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/left-sidebar.png',
                    'right-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/right-sidebar.png',
                ],
                'default' => 'left-sidebar',
            ],
            [
                'id' => 'single_post_entry_meta',
                'type' => 'checkbox',
                'title' => esc_html__('Entry Meta', 'chakavak'),
                'default' => ['date', 'author', 'comm'],
                'inline' => true,
                'options' => [
                    'date' => esc_html__('Date', 'chakavak'),
                    'author' => esc_html__('Author', 'chakavak'),
                    'comm' => esc_html__('Comment', 'chakavak'),
                ],
            ],
            [
                'id' => 'sw_single_post_socials',
                'type' => 'switcher',
                'title' => esc_html__('Enable Social Share', 'chakavak'),
                'default' => true
            ],

            [
                'id' => 'single_post_socials',
                'type' => 'checkbox',
                'title' => esc_html__('List of sharing post', 'chakavak'),
                'default' => ['linkedin', 'telegram', 'whatsapp'],
                'inline' => true,
                'options' => [
                    'facebook' => esc_html__('Facebook', 'chakavak'),
                    'twitter' => esc_html__('Twitter', 'chakavak'),
                    'linkedin' => esc_html__('Linkedin', 'chakavak'),
                    'telegram' => esc_html__('Telegram', 'chakavak'),
                    'whatsapp' => esc_html__('Whatsapp', 'chakavak'),
                ],
                'dependency' => ['sw_single_post_socials', '==', true,],
            ],

            [
                'id' => 'single_post_link',
                'type' => 'switcher',
                'title' => esc_html__('Enable short link', 'chakavak'),
                'default' => true
            ],
            [
                'id' => 'single_post_author_box',
                'type' => 'switcher',
                'title' => esc_html__('Show Author box', 'chakavak'),
                'default' => true
            ],
            [
                'id' => 'single_post_post_nav',
                'type' => 'switcher',
                'title' => esc_html__('Show Post Navigation', 'chakavak'),
                'default' => true
            ],
            [
                'id' => 'single_post_related',
                'type' => 'switcher',
                'title' => esc_html__('Show Related post', 'chakavak'),
                'default' => true
            ],
            [
                'id' => 'related_card_title_tag',
                'type' => 'select',
                'title' => esc_html__('Card Title Tag', 'chakavak'),
                'subtitle' => esc_html__('Select Title HTML Tag', 'chakavak'),
                'placeholder' => esc_html__('Select an option', 'chakavak'),
                'options' => chakavak_heading(),
                'default' => 'h4',
                'dependency' => ['single_post_related', '==', 'true'],
            ],
        ]
    ]);
}
