<?php
/*
 * Theme Metabox
 * @package Chakavak
 * @since 1.0.0
 * */
defined('ABSPATH') or exit;
if (class_exists('CSF')) {
    $prefix = 'chakavak';

    /*Page Site Options */
    $taxonomy_metabox = 'chakavak_taxonomy_meta';

    CSF::createTaxonomyOptions($taxonomy_metabox, [
        'title' => esc_html__('Other Options', 'chakavak'),
        'taxonomy'  => ['portfolio_cat', 'category', 'post_tag'],
        'data_type' => 'serialize',
        'theme' => 'light',
        'show_restore' => true,
        'class' => 'chakavak-metabox-options',
    ]);

    //page options
    CSF::createSection($taxonomy_metabox, [
        'title' => esc_html__('Page Options', 'chakavak'),
        'icon' => 'ai-articles',
        'fields' => [
            [
                'id' => 'tax_desc',
                'type' => 'wp_editor',
                'title' => esc_html__('Description', 'chakavak'),
                'tinymce' => true,
                'quicktags' => true,
                'media_buttons' => true,
                'height' => '300px',
            ],

            [
                'id' => 'faq_switch',
                'type' => 'switcher',
                'title' => esc_html__('Enable FAQ', 'chakavak'),
                'default' => false,
            ],

            [
                'id' => 'faq_schema_switch',
                'type' => 'switcher',
                'title' => esc_html__('Enable Schema for FAQ', 'chakavak'),
                'default' => false,
                'dependency' => ['faq_switch', '==', 'true'],
            ],

            [
                'id'     => 'faq_items',
                'type'   => 'group',
                'title'  => esc_html__('FAQ', 'chakavak'),
                'dependency' => ['faq_switch', '==', 'true'],
                'button_title'    => esc_html__('Add New', 'chakavak'),
                'accordion_title' => esc_html__('FAQ New', 'chakavak'),
                'fields' => [
                    [
                        'id'    => 'question',
                        'type'  => 'textarea',
                        'title' => esc_html__('Question', 'chakavak'),
                    ],
                    [
                        'id'            => 'answer',
                        'type'          => 'wp_editor',
                        'title'         => esc_html__('answer', 'chakavak'),
                        'tinymce'       => true,
                        'quicktags'     => true,
                        'media_buttons' => false,
                        'height'        => '120px',
                    ]
                ]
            ]

        ]
    ]);
}
