<?php
/*
 * Theme Metabox
 * @package Chakavak
 * @since 1.0.0
 * */

defined('ABSPATH') or exit;
if (class_exists('CSF')) {
    $prefix = 'chakavak';

    /*Page Site Options */
    $portfolio_metabox = 'chakavak_portfolio_meta';

    CSF::createMetabox($portfolio_metabox, [
        'title' => esc_html__('Portfolio Options', 'chakavak'),
        'post_type' => ['portfolio'],
        'theme' => 'light',
        'show_restore' => true,
        'class' => 'chakavak-metabox-options',
    ]);

    //page options
    CSF::createSection($portfolio_metabox, [
        'title' => esc_html__('Options', 'chakavak'),
        'icon' => 'ai-articles',
        'fields' => [
            [
                'id' => 'portfolio_page_design',
                'type' => 'button_set',
                'title' => esc_html__('Page Design', 'chakavak'),
                "options" => [
                    "elementor" => esc_html__('Elementor Design', 'chakavak'),
                    "default" => esc_html__('Default', 'chakavak'),
                ],
                'default' => 'default',
                'multiple' => false,
            ],

            /*Page header options*/
            [
                'id' => 'page_header_switch',
                'type' => 'switcher',
                'title' => esc_html__('Activate Page Header', 'chakavak'),
                'default' => true,
            ],

            [
                'id' => 'page_header_bg_image',
                'type' => 'media',
                'title' => esc_html__('Background Page Header', 'chakavak'),
                'library' => 'image',
                'preview' => true,
                'dependency' => [
                    'page_header_switch',
                    '==',
                    'true'
                ],
            ],

        ],
    ]);
    CSF::createSection($portfolio_metabox, [
        'title' => esc_html__('Portfolio info', 'chakavak'),
        'icon' => 'ai-articles',
        'fields' => [
            [
                'id' => 'portfolio_features',
                'type' => 'group',
                'title' => esc_html__('Portfolio Features', 'chakavak'),
                'subtitle' => esc_html__('Add custom portfolio features', 'chakavak'),
                'button_title' => esc_html__('Add feature', 'chakavak'),
                'accordion_title' => esc_html__('New feature', 'chakavak'),
                'fields' => [
                    [
                        'id' => 'feature_label',
                        'type' => 'text',
                        'title' => esc_html__('Label', 'chakavak'),
                        'placeholder' => esc_html__('Employer eg.', 'chakavak'),
                    ],
                    [
                        'id' => 'feature_value',
                        'type' => 'text',
                        'title' => esc_html__('Value', 'chakavak'),
                        'placeholder' => esc_html__('Mr.Ahmadi eg.', 'chakavak'),
                    ],
                ],
                'default' => [
                    [
                        'feature_label' => esc_html__('Employer name', 'chakavak'),
                        'feature_value' => esc_html__('Mr.Ahmadi', 'chakavak'),
                    ],
                    [
                        'feature_label' => esc_html__('Year of implementation', 'chakavak'),
                        'feature_value' => esc_html__('1403', 'chakavak'),
                    ],
                ],
            ],
            [
                'id' => 'portfolio_summary',
                'type' => 'wp_editor',
                'title' => esc_html__('Short Description', 'chakavak'),
                'tinymce' => true,
                'quicktags' => true,
                'media_buttons' => false,
                'height' => '200px',
            ],
        ]
    ]);
}
