<?php
/*
 * Theme Metabox
 * @package Chakavak
 * @since 1.0.0
 * */
defined('ABSPATH') or exit;
if (class_exists('CSF')) {
    $prefix = 'chakavak';

    /*Page Site Options */
    $page_metabox = 'chakavak_page_meta';

    CSF::createMetabox($page_metabox, [
        'title' => esc_html__('Page Options', 'chakavak'),
        'post_type' => ['page'],
        'theme' => 'light',
        'show_restore' => true,
        'class' => 'chakavak-metabox-options',
    ]);

    //page options
    CSF::createSection($page_metabox, [
        'title' => esc_html__('Page Settings', 'chakavak'),
        'icon' => 'ai-articles',
        'fields' => [
            [
                'type' => 'subheading',
                'content' => esc_html__('Page Settings', 'chakavak'),
            ],

            [
                'id' => 'page_layout',
                'type' => 'image_select',
                'title' => esc_html__('Page Layout', 'chakavak'),
                'options' => [
                    'full-content' => CHAKAVAK_BACKEND_ASSETS . 'images/full-width.png',
                    'left-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/left-sidebar.png',
                    'right-sidebar' => CHAKAVAK_BACKEND_ASSETS . 'images/right-sidebar.png',
                ],
                'default' => 'full-content',
            ],

            [
                'id' => 'page_content_width',
                'type' => 'button_set',
                'title' => esc_html__('Page Content width', 'chakavak'),
                "options" => [
                    "full-width" => esc_html__('Full Width', 'chakavak'),
                    "container" => esc_html__('Boxed', 'chakavak'),
                ],
                'default' => 'container',
                'multiple' => false,
            ],

            [
                'id' => 'page_content_padding',
                'type' => 'button_set',
                'title' => esc_html__('Page Content Top and Bottom Padding', 'chakavak'),
                "options" => [
                    "padding-default" => esc_html__('Default', 'chakavak'),
                    "p-0" => esc_html__('No Padding', 'chakavak'),
                ],
                'default' => 'padding-default',
                'multiple' => false,
            ],

            /*Page header options*/

            [
                'type' => 'subheading',
                'content' => esc_html__('Page Header', 'chakavak'),
            ],

            [
                'id' => 'page_header_switch',
                'type' => 'switcher',
                'title' => esc_html__('Activate Page Header', 'chakavak'),
                'default' => true,
            ],

            [
                'id' => 'page_header_bg_image',
                'type' => 'media',
                'title' => esc_html__('Background Page Header', 'chakavak'),
                'library' => 'image',
                'preview' => true,
                'dependency' => ['page_header_switch', '==', 'true'],
            ],

        ],
    ]);

    // Header Section
    CSF::createSection($page_metabox, [
        'title' => esc_html__('Header & Footer', 'chakavak'),
        'icon' => 'ai-header',
        'fields' => [

            [
                'type' => 'subheading',
                'content' => esc_html__('Header Option', 'chakavak'),
            ],

            [
                'id' => 'select_header',
                'type' => 'select',
                'title' => esc_attr__('Select Header Desktop', 'chakavak'),
                'desc' => esc_attr__('Choose the header on desktop.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select Header', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                    'posts_per_page' => -1,
                    'orderby' => 'date',
                    'order' => 'ASC',
                ],
            ],

            [
                'id' => 'header_is_trans',
                'title' => esc_html__('Header transparent ?', 'chakavak'),
                'type' => 'select',
                'chosen' => true,
                'options' => array(
                    'default' => esc_html__('Default', 'chakavak'),
                    'yes' => esc_html__('Yes', 'chakavak'),
                    'no' => esc_html__('No', 'chakavak'),
                ),
                'default' => 'default'
            ],

            [
                'id' => 'select_header_mobile',
                'type' => 'select',
                'title' => esc_attr__('Select Header Mobile', 'chakavak'),
                'desc' => esc_attr__('Choose the header on mobile.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select Header', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                    'posts_per_page' => -1,
                    'orderby' => 'date',
                    'order' => 'ASC',
                ],
            ],

            /*Footer*/
            [
                'type' => 'subheading',
                'content' => esc_html__('Footer Option', 'chakavak'),
            ],

            [
                'id' => 'select_footer',
                'type' => 'select',
                'title' => esc_attr__('Select footer', 'chakavak'),
                'desc' => esc_attr__('Choose the footer.', 'chakavak'),
                'chosen' => true,
                'placeholder' => esc_attr__('Select footer', 'chakavak'),
                'options' => 'posts',
                'query_args' => [
                    'post_type' => 'chk_builders',
                    'posts_per_page' => -1,
                    'orderby' => 'date',
                    'order' => 'ASC',
                ],
            ],

        ],
    ]);
}
