<?php
defined('ABSPATH') or exit;
/**
 * custom_wp_admin_style
 */
if (!function_exists('chakavak_custom_wp_admin_style')) :
    function chakavak_custom_wp_admin_style()
    {
        wp_register_style('chakavak_admin_css', CHAKAVAK_BACKEND_ASSETS . 'css/admin-style.min.css', false, '1.0.0');
        wp_enqueue_style('chakavak_admin_css');
        wp_register_style('chakavak_admin_icons', CHAKAVAK_BACKEND_ASSETS . 'css/admin-icons.min.css', false, '1.0.0');
        wp_enqueue_style('chakavak_admin_icons');

        wp_register_style('chakavak_codestar_css', CHAKAVAK_BACKEND_ASSETS . 'css/custom-codestar.min.css', false, '1.0.0');
        wp_enqueue_style('chakavak_codestar_css');
    }

    add_action('admin_enqueue_scripts', 'chakavak_custom_wp_admin_style');
endif;

/**
 * Upload SVG file
 */
function chakavak_types_to_uploads($file_types)
{
    $new_filetypes = array();
    $new_filetypes['svg'] = 'image/svg+xml';
    $new_filetypes['svgz'] = 'image/svg+xml';

    return array_merge($file_types, $new_filetypes);
}

add_filter('upload_mimes', 'chakavak_types_to_uploads');

/**
 * upload webp
 */
function chakavak_upload_mimes($existing_mimes)
{
    $existing_mimes['webp'] = 'image/webp';

    return $existing_mimes;
}

add_filter('mime_types', 'chakavak_upload_mimes');

/**
 * Enable preview / thumbnail for webp image files
 */
function chakavak_is_displayable($result, $path)
{
    if ($result === false) {
        $displayable_image_types = array(IMAGETYPE_WEBP);
        $info = @getimagesize($path);

        if (empty($info)) {
            $result = false;
        } elseif (!in_array($info[2], $displayable_image_types)) {
            $result = false;
        } else {
            $result = true;
        }
    }

    return $result;
}

add_filter('file_is_displayable_image', 'chakavak_is_displayable', 10, 2);

/*remove avatar admin panel */
//add_filter( 'option_show_avatars', '__return_false' );


add_action('admin_init', 'chakavak_remove_default_stylesheets');
function chakavak_remove_default_stylesheets()
{
    wp_deregister_style('elementor-admin-top-bar-fonts');
}

/**
 *How to Remove WordPress Logo from Admin Bar
 */
function chakavak_admin_bar_remove_logo()
{
    global $wp_admin_bar;

    $wp_admin_bar->remove_menu('wp-logo');
    $wp_admin_bar->remove_menu('wpseo-menu');
    $wp_admin_bar->remove_menu('rank-math');
    //$wp_admin_bar->remove_menu('my-account'); // my-account menu
    //$wp_admin_bar->remove_menu('user-actions'); // dropdown menu user
    /* $wp_admin_bar->remove_menu('user-info'); // user-info dropdown menu user
    $wp_admin_bar->remove_menu('edit-profile'); // edit-profile dropdown menu user
    $wp_admin_bar->remove_menu('logout'); // logout dropdown menu user */
    $wp_admin_bar->remove_menu('search'); // search menu
    $wp_admin_bar->remove_menu('themes'); // remove themes in 'site-name'
    //$wp_admin_bar->remove_menu( 'customize' ); // remove customize
    $wp_admin_bar->remove_menu('updates'); // remove updates
    $wp_admin_bar->remove_menu('new-media'); // remove new-media sub-menu content
    $wp_admin_bar->remove_menu('new-user'); // remove new-user sub-menu content
}

add_action('wp_before_admin_bar_render', 'chakavak_admin_bar_remove_logo', 0);

/**
 * Let to Number
 */
function chakavak_let_to_num($v)
{
    $l = substr($v, -1);
    $ret = substr($v, 0, -1);
    switch (strtoupper($l)) {
        case 'P':
            $ret *= 1024;
        case 'T':
            $ret *= 1024;
        case 'G':
            $ret *= 1024;
        case 'M':
            $ret *= 1024;
        case 'K':
            $ret *= 1024;
            break;
    }

    return $ret;
}

/**
 * Memory Limit
 */
function chakavak_memory_limit()
{
    $limit = chakavak_let_to_num(WP_MEMORY_LIMIT);
    if (function_exists('memory_get_usage')) {
        $limit = max($limit, chakavak_let_to_num(@ini_get('memory_limit')));
    }

    return $limit;
}

//Remove dashboard Metaboxes
function chakavak_remove_dashboard_meta()
{
    remove_meta_box('duplicator_dashboard_widget', 'dashboard', 'normal');
    remove_meta_box('wpp_dashboard_primary', 'dashboard', 'normal');
    remove_meta_box('persian_woocommerce_feed', 'dashboard', 'normal');
    remove_meta_box('dashboard_primary', 'dashboard', 'normal');
}

add_action('admin_init', 'chakavak_remove_dashboard_meta');
