<?php

/**
 * The template for displaying comments
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package chakavak
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
    return;
}
$author_error = esc_html__('Name is required', 'chakavak');
$email_error = esc_html__('Email is required', 'chakavak');
$comment_error = esc_html__('Comment is required', 'chakavak');
?>
<div id="comments" class="chk-comments__area" data-name="<?php echo $author_error; ?>" data-email="<?php echo $email_error; ?>" data-comment="<?php echo $comment_error; ?>">
    <?php
    // You can start editing here -- including this comment!
    if (have_comments()) : ?>

        <span class="chk-comments__count">
            <?php
            $comment_count = get_comments_number();
            if ($comment_count == 0) {
                printf(esc_html__('0 Comment for %s', 'chakavak'), get_the_title());
            } elseif ($comment_count == 1) {
                printf(esc_html__('1 Comment for %s', 'chakavak'), get_the_title());
            } else {
                printf(esc_html__('%d Comments for %s', 'chakavak'), $comment_count, get_the_title());
            }
            ?>
        </span>

        <ol class="comment__list">
            <?php wp_list_comments('callback=chakavak_comment_list'); ?>
        </ol><!-- .comment-list -->

        <?php
        the_comments_navigation();

        // If comments are closed and there are comments, let's leave a little note, shall we?
        if (!comments_open()) :
        ?>
            <p class="no-comments">
                <?php esc_html_e('Comments are closed.', 'chakavak'); ?>
            </p>
    <?php
        endif;

    endif; // Check for have_comments().
    // Custom comments_args here: https://codex.wordpress.org/Function_Reference/comment_form
    $commenter = wp_get_current_commenter();
    $req = get_option('require_name_email');
    $aria_req = ($req ? " aria-required='true'" : '');

    $comments_args = array(
        'title_reply' => esc_html__('Write your comment', 'chakavak'),
        'comment_field' => '<div class="row"><div class="chk-comment-form__message col-xs-12"><textarea id="comment" name="comment" cols="45" rows="6" aria-required="true" placeholder="' . esc_attr__('Comment*', 'chakavak') . '" required></textarea></div>',
        'fields' => apply_filters('comment_form_default_fields', array(
            'author' =>
            '<div class="chk-comment-form__author col-xs-12 col-md-6"><input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) .
                '" size="30" placeholder="' . esc_attr__('Name*', 'chakavak') . '" required /></div>',

            'email' =>
            '<div class="chk-comment-form__email col-xs-12 col-md-6"><input id="email" name="email" type="email" value="' . esc_attr($commenter['comment_author_email']) .
                '" size="30" placeholder="' . esc_attr__('Email*', 'chakavak') . '" required /></div></div>',
        )),
        'class_submit' => 'chk-comment-form__submit',
        'format' => 'xhtml'
    );
    comment_form($comments_args);
    ?>
</div>