(function ($) {
    ("use strict");

    let CHAKAVAK = {},
        $window = $(window),
        $document = $(document),
        $body = $("body");

    /* rtl check */
    function rtl_isotop() {
        if ($('body').hasClass("rtl")) {
            return false;
        } else {
            return true;
        }
    }


    /*
    * Sticky Header
    */
    CHAKAVAK.stickyHeader = function () {
        $('.chk-header__static .is-fixed').parent().append('<div class="chk-header__clone"></div>');
        $('.chk-header__clone').height($('#chk-header__site .is-fixed').outerHeight());
        $('.chk-header__static .chk-header__clone').hide();
        $(window).on("scroll", function () {
            var site_header = $('#chk-header__site').outerHeight() + 1;
            if ($(window).scrollTop() >= site_header) {
                $('.chk-header__site .is-fixed').addClass('chk-is-stuck');
                $('.chk-header__static .chk-header__clone').show();
                $('.chk-header__site .chk-header-item').addClass('scrolled');
            } else {
                $('.chk-header__site .is-fixed').removeClass('chk-is-stuck');
                $('.chk-header__static .chk-header__clone').hide();
                $('.chk-header__site .chk-header-item').removeClass('scrolled');
            }
        });
    };

    /**
     * Mobile Navigation
     */
    CHAKAVAK.headerMobileDefault = function () {
        $('.chk-mobile__default-menu li:has(ul)').prepend('<span class="arrow"><i class="ti-arrow-down"></i></span>');
        $(".chk-mobile__default-menu > li span.arrow").on('click', function () {
            $(this).parent().find("> ul").stop(true, true).slideToggle();
            $(this).parent().toggleClass("show-submenu");
            $(this).toggleClass("active");
        });

        $(".chk-mmenu__toggle").on('click', function () {
            $(this).toggleClass("active");
            $(this).parents('.chk-header__mobile').toggleClass("open");
            if ($(this).hasClass("active")) {
                $('.chk-mobile__default-nav').stop(true, true).slideDown(100);
            } else {
                $('.chk-mobile__default-nav').stop(true, true).slideUp(100);
            }
        });
    };

    /*
    * Progress Bar
    */
    CHAKAVAK.progressBar = function () {
        let scrollTopbtn = document.querySelector(".chk-progress__wrap");
        let progressPath = document.querySelector(".chk-progress__wrap path");
        var pathLength = progressPath.getTotalLength();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
        progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
        progressPath.style.strokeDashoffset = pathLength;
        progressPath.getBoundingClientRect();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
        var updateProgress = function () {
            var scroll = $(window).scrollTop();
            var height = $(document).height() - $(window).height();
            var progress = pathLength - (scroll * pathLength / height);
            progressPath.style.strokeDashoffset = progress;
        }
        updateProgress();
        $(window).scroll(updateProgress);
        var offset = 50;
        var duration = 750;
        jQuery(window).on('scroll', function () {
            if (jQuery(this).scrollTop() > offset) {
                jQuery(scrollTopbtn).addClass('active-progress');
            } else {
                jQuery(scrollTopbtn).removeClass('active-progress');
            }
        });

        jQuery(scrollTopbtn).on('click', function (event) {
            event.preventDefault();
            jQuery('html, body').animate({
                scrollTop: 0
            }, duration);
            return false;
        })
    };

    /*
    * FAQ Acc
    */
    CHAKAVAK.accFaqs = function () {
        $(".chk-faq-item > .acc-title").on("click", function () {
            var $faqItem = $(this).parent();
            var $content = $(this).siblings(".acc-content");
            if ($faqItem.hasClass("active")) {
                $faqItem.removeClass("active");
                $content.slideUp(200);
            } else {
                $(".chk-faq-item").removeClass("active");
                $(".acc-content").slideUp(200);

                $faqItem.addClass("active");
                $content.slideDown(200);
            }
        });
    }

    /*
    * Grid Masonray
    */
    CHAKAVAK.gridMasonry = function () {
        var $container = $('.chk-grid-masonry');
        $container.isotope({
            itemSelector: '.col-xs',
            layoutMode: 'masonry',
            isOriginLeft: rtl_isotop()
        });
    }

    /*
   * Preloader
   */
    CHAKAVAK.preloader = function () {
        $("#chk-preloader").delay(0).fadeOut("slow");
    };

    /*
    * Icon Search
    */
    let chakavakIconSearch = function () {
        $(".chk-isearch-open").on("click", function (e) {
            e.preventDefault();
            $(".chk-isearch__popup").toggleClass("active");
            $("body").toggleClass("locked");
        });
    }

    /** * Elementor Header */

    let chakavakMenu = function () {
        const $menu_wrap = $('.chk-navbar__menu');
        const $li_megamenu = $('.chk-navbar li.chk-megamenu');
        $menu_wrap.parents('.e-con-inner,.elementor-container').addClass('chk-position-menu');
        $li_megamenu.parents("li.menu-item-has-children").addClass("chk-megamenu__wrap");
        $("ul.nav-dropdown").each(function () {
            if ($(this).children("li.chk-megamenu").length > 0) {
                $(this).addClass("nav-dropdown-megamenu");
            } else {
                $(this).addClass("nav-dropdown-simple");
            }
        });
    }

    /** Mobile Menu */
    let chakavakMobileMenuPanel = function () {
        const $btnToggle = $('#chk-mmenu-toggle');
        const $mmenu = $('.chk-mmenu__wrapper');
        const $body = $('body');

        $('#chk-mmenu-toggle, .chk-mmenu__close, .chk-mmenu-overlay').on('click', function (e) {
            e.preventDefault();
            const isActive = !$btnToggle.hasClass('active');
            $btnToggle.toggleClass('active', isActive);
            $mmenu.toggleClass('mmenu-open', isActive);
            $body.toggleClass('mmenu-active', isActive);
        });

        $('.chk-mmenu__nav li:has(ul)').prepend('<span class="arrow transition-all"><i class="ti-arrow-down"></i></span>');
        $(".chk-mmenu__items > li span.arrow").on('click', function () {
            $(this).parent().find("> ul").stop(true, true).slideToggle();
            $(this).parent().toggleClass("show-submenu");
            $(this).toggleClass("active");
        });

        const $li_megamenu = $('.chk-mmenu__items li.chk-megamenu');
        $li_megamenu.parents("li.menu-item-has-children").addClass("chk-megamenu__wrap");
        $("ul.nav-dropdown").each(function () {
            if ($(this).children("li.chk-megamenu").length > 0) {
                $(this).addClass("nav-dropdown-megamenu");
            } else {
                $(this).addClass("nav-dropdown-simple");
            }
        });
    }

    /** vertical Menu */
    let chakavakverticalMenu = function () {
        $('.chk-vmenu__nav li:has(ul)').prepend('<span class="arrow transition-all"><i' +
            ' class="ti-arrow-down"></i></span>');
        $(".chk-vmenu__items > li span.arrow").on('click', function () {
            $(this).parent().find("> ul").stop(true, true).slideToggle();
            $(this).parent().toggleClass("show-submenu");
            $(this).toggleClass("active");
        });

        const $li_megamenu = $('.chk-vmenu__items li.chk-megamenu');
        $li_megamenu.parents("li.menu-item-has-children").addClass("chk-megamenu__wrap");
        $("ul.nav-dropdown").each(function () {
            if ($(this).children("li.chk-megamenu").length > 0) {
                $(this).addClass("nav-dropdown-megamenu");
            } else {
                $(this).addClass("nav-dropdown-simple");
            }
        });
    }

    /** Sidepanel */
    let chakavakSidePanel = function () {
        const $btnToggle = $('.chk-sidepanel__btn');
        const $sidepanel = $('.chk-sidepanel__wrapper');
        const $body = $('body');
        const $toggleElements = $('.chk-sidepanel__btn, .chk-sidepanel__close, .chk-sidepanel__overlay');

        $toggleElements.on('click', function (e) {
            e.preventDefault();
            const isActive = !$btnToggle.hasClass('active');
            $btnToggle.toggleClass('active', isActive);
            $sidepanel.toggleClass('sidepanel-open', isActive);
            $body.toggleClass('sidepanel-active', isActive);
        });
    };


    /* $windows frontend elementor */
    $(window).on("elementor/frontend/init", function () {
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_menu.default", chakavakMenu);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_mmobile.default", chakavakMobileMenuPanel);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_search_icon.default", chakavakIconSearch);
        elementorFrontend.hooks.addAction("frontend/element_ready/chk_vmenu.default", chakavakverticalMenu);
    });


    /**
     * document ready
     */
    $window.on("resize", function () {
    });

    $window.load(function () {
        if ($(".chk-progress__wrap").length) {
            CHAKAVAK.progressBar();
        }

        if ($("#chk-preloader").length) {
            CHAKAVAK.preloader();
        }

        if ($(".chk-grid-masonry").length) {
            CHAKAVAK.gridMasonry();
        }

        if ($(".is-fixed").length) {
            CHAKAVAK.stickyHeader();
        }
    });

    $document.ready(function () {
        if ($(".chk-mobile__default-nav").length) {
            CHAKAVAK.headerMobileDefault();
        }
        if ($(".chk-isearch-open").length) {
            chakavakIconSearch();
        }
        if ($(".chk-sidepanel__btn").length) {
            chakavakSidePanel();
        }
        if ($(".chk-faq-items").length) {
            CHAKAVAK.accFaqs();
        }
    });

})(jQuery);
