<?php

/**
 * @package Chakavak
 */
get_header();
?>
<div class="padding-default">
    <div class="container">
        <div class="d-flex flex-wrap">
            <div id="chk-archive-portfolio" class="chk-archive-portfolio <?php chakavak_content_columns(); ?>">
                <main id="main" class="site-main">
                    <?php if (chakavak_get_option('archive_portfolio_desc') == 'top-desc') {
                        if (get_the_archive_description()) { ?>
                            <div class="chk-archive-desc top-desc">
                                <?php echo get_template_part('template-parts/category/description'); ?>
                            </div>
                    <?php }
                    } ?>

                    <?php if (have_posts()) : ?>
                        <div class="<?php chakavak_archive_portfolio_columns_class();
                                    chakavak_portfolio_style() ?> ">
                            <?php while (have_posts()) {
                                the_post(); ?>
                                <div class="col-xs">
                                    <?php get_template_part('template-parts/content', get_post_type()); ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php else :
                        get_template_part('template-parts/content', 'none');
                    endif; ?>

                    <?php chakavak_posts_navigation('standard'); ?>

                    <?php if (chakavak_get_option('archive_portfolio_desc') == 'bottom-desc') {
                        if (get_the_archive_description()) { ?>
                            <div class="chk-archive-desc bottom-desc">
                                <?php echo get_template_part('template-parts/category/description'); ?>
                            </div>
                    <?php }
                    } ?>
                </main>
            </div>

            <?php get_sidebar('portfolio'); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>